/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.MavenPluginParameters;
import com.mulesoft.exchange.mavenfacade.PublicationPreConditionsChecker;
import com.mulesoft.exchange.mavenfacade.PublicationPreConditionsProvider;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="exchange-pre-deploy")
public class PreConditionsMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        MavenPluginParameters mavenPluginParameters = new MavenPluginParameters(this.mavenProject, this.mavenSession, this.pluginManager, this.getLog());
        ArtifactRepository repository = mavenPluginParameters.getMavenProject().getDistributionManagementArtifactRepository();
        ExchangeUriChecker.validateMavenV3RunIdUri((String)repository.getUrl());
        PublicationPreConditionsProvider publicationStatusProvider = new PublicationPreConditionsProvider(mavenPluginParameters);
        PublicationPreConditionsChecker publicationPreConditionsChecker = new PublicationPreConditionsChecker(publicationStatusProvider, this.getLog());
        try {
            publicationPreConditionsChecker.checkStatus();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exchange publication failed", e);
        }
        this.getLog().info((CharSequence)"Everything ok!");
    }
}

