/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.ExchangeEOFDeployer;
import com.mulesoft.exchange.mavenfacade.MavenPluginParameters;
import com.mulesoft.exchange.mavenfacade.PublicationStatusChecker;
import com.mulesoft.exchange.mavenfacade.PublicationStatusProvider;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="exchange-deploy")
public class PublicationMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        MavenPluginParameters mavenPluginParameters = new MavenPluginParameters(this.mavenProject, this.mavenSession, this.pluginManager, this.getLog());
        ArtifactRepository repository = mavenPluginParameters.getMavenProject().getDistributionManagementArtifactRepository();
        ExchangeUriChecker.validateMavenV3RunIdUri((String)repository.getUrl());
        ExchangeEOFDeployer exchangeEOFDeployer = new ExchangeEOFDeployer(mavenPluginParameters);
        PublicationStatusProvider publicationStatusProvider = new PublicationStatusProvider(mavenPluginParameters);
        PublicationStatusChecker publicationStatusChecker = new PublicationStatusChecker(publicationStatusProvider, this.getLog());
        try {
            exchangeEOFDeployer.deploy();
            publicationStatusChecker.checkStatus();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exchange publication failed", e);
        }
        this.getLog().info((CharSequence)"Everything ok!");
    }
}

