package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.dto.Validation;
import org.apache.maven.plugin.logging.Log;

public class PublicationPreConditionsChecker {

    private PublicationPreConditionsProvider publicationPreConditionsProvider;
    private Log logger;

    public PublicationPreConditionsChecker(PublicationPreConditionsProvider publicationPreConditionsProvider, Log logger) {
        this.publicationPreConditionsProvider = publicationPreConditionsProvider;
        this.logger = logger;
    }

    public void checkStatus() throws InterruptedException {
        Validation validation = new Validation();
        validation = publicationPreConditionsProvider.getStatus();

        // Check error step
        if (validation.getStatus().equals("error")) {
            logger.info("  ------------------------------------------------------------");
            logger.info("  Publication status: error");
            logger.info("  ------------------------------------------------------------");

            if (validation.getErrors() != null && !validation.getErrors().isEmpty()) {
                logger.info("    - Errors: " + validation.getErrors());
            }

            throw new RuntimeException("Publication ended with errors");
        }
    }
}
