package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.dto.Status;
import com.mulesoft.exchange.mavenfacade.dto.Step;
import org.apache.maven.plugin.logging.Log;

import java.util.List;

public class PublicationStatusChecker {

    private static final Integer GET_STATUS_MAX_RETRIES = 30;
    private static final Integer GET_STATUS_DELAY = 1000;

    private PublicationStatusProvider publicationStatusProvider;
    private Log logger;

    public PublicationStatusChecker(PublicationStatusProvider publicationStatusProvider, Log logger) {
        this.publicationStatusProvider = publicationStatusProvider;
        this.logger = logger;
    }

    public void checkStatus() throws InterruptedException {
        Status status = new Status("initial");
        int attempt = 0;

        while (!status.getStatus().equals("completed") && !status.getStatus().equals("error")) {
            logger.info("Getting publication status");

            if (attempt > GET_STATUS_MAX_RETRIES) {
                throw new RuntimeException("Asset publication didn't finish in the expected time");
            }

            try {
                status = publicationStatusProvider.getStatus();

                logger.info("  ------------------------------------------------------------");
                logger.info("  Publication status: " + status.getStatus());
                logger.info("  ------------------------------------------------------------");
                logger.info("    Steps: ");

                for (Step step : status.getSteps()) {
                    logger.info("    - Description: " + step.getDescription());
                    logger.info("    - Status: " + step.getStatus());

                    if (step.getErrors() != null && !step.getErrors().isEmpty()) {
                        logger.info("    - Errors: " + step.getErrors());
                    }

                    logger.info("    .........................................");
                }
            } catch (Exception e) {
                logger.warn("Failed to get publication status", e);
            }

            Thread.sleep(GET_STATUS_DELAY);
            attempt++;
        }

        // Check error step
        if (status.getStatus().equals("error")) {
            List<Step> steps = status.getSteps();
            Step lastStep = steps.get(steps.size() - 1);

            throw new RuntimeException("Publication ended with errors: " + lastStep.getErrors());
        }
    }
}
