/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.google.common.collect.Lists;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeHelper;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractExchangeMojo
extends AbstractMojo {
    @Component
    protected MavenProject mavenProject;
    @Component
    protected MavenSession mavenSession;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter
    protected List<String> customDomains = new ArrayList<String>();
    ExchangeUriChecker exchangeUriChecker;

    public void execute() throws MojoExecutionException {
        this.initMojo();
        this.doExecute();
    }

    public abstract void doExecute() throws MojoExecutionException;

    private void initMojo() {
        Set storedCustomDomains = new ExchangeHelper().retrieveCustomDomains(this.mavenSession.getSystemProperties());
        storedCustomDomains.addAll(this.customDomains);
        this.exchangeUriChecker = new ExchangeUriChecker((List)Lists.newArrayList((Iterable)storedCustomDomains));
    }
}

