/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.IOUtil;
import org.mule.tools.maven.plugin.app.AbstractMuleMojo;

public class MuleInstallMojo
extends AbstractMuleMojo {
    protected boolean installDomain;
    protected String domainDependency;
    protected boolean copyToAppsDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.copyToAppsDirectory) {
            File muleHome = this.determineMuleHome();
            if (muleHome != null) {
                if (this.installDomain) {
                    if (this.domainDependency == null || this.domainDependency.trim().equals("") || this.domainDependency.equals("empty")) {
                        throw new MojoExecutionException("You must configure the domainDependency configuration attribute and specify the domain dependency in order to install the domain in the mule server");
                    }
                    String[] split = this.domainDependency.split(":");
                    if (split.length != 3) {
                        throw new MojoExecutionException("domainDependency attribute does not declare groupId or artifactId or version");
                    }
                    String domainGroupId = split[0];
                    String domainArtifactId = split[1];
                    String domainVersion = split[2];
                    Set dependencyArtifacts = this.project.getDependencyArtifacts();
                    boolean domainFound = false;
                    for (Object dependencyArtifact : dependencyArtifacts) {
                        Artifact artifact = (Artifact)dependencyArtifact;
                        if (!artifact.getGroupId().equals(domainGroupId) || !artifact.getArtifactId().equals(domainArtifactId) || !artifact.getVersion().equals(domainVersion)) continue;
                        domainFound = true;
                        try {
                            this.copyZipFileToDestDirUsingTempFile(artifact.getFile(), new File(muleHome, "domains"));
                            break;
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException(e.getMessage(), (Exception)e);
                        }
                    }
                    if (!domainFound) {
                        throw new MojoExecutionException("installDomain was configured but domain dependency is not available in the project. Did you forgot to add the domain as a dependency with type zip?");
                    }
                }
                this.copyMuleAppZipToMuleHome(muleHome);
            } else {
                this.getLog().warn((CharSequence)("MULE_HOME is not set, not copying " + this.finalName + ".zip"));
            }
        }
    }

    private File determineMuleHome() throws MojoExecutionException {
        File muleHomeFile = null;
        String muleHome = this.getMuleHomeEnvVarOrSystemProperty();
        if (muleHome != null) {
            muleHomeFile = new File(muleHome);
            if (!muleHomeFile.exists()) {
                String message = String.format("MULE_HOME is set to %1s but this directory does not exist.", muleHome);
                throw new MojoExecutionException(message);
            }
            if (!muleHomeFile.canWrite()) {
                String message = String.format("MULE_HOME is set to %1s but the directory is not writeable.", muleHome);
                throw new MojoExecutionException(message);
            }
        }
        return muleHomeFile;
    }

    private String getMuleHomeEnvVarOrSystemProperty() {
        String muleHome = System.getProperty("mule.home");
        if (muleHome == null) {
            muleHome = System.getenv("MULE_HOME");
        }
        return muleHome;
    }

    private void copyMuleAppZipToMuleHome(File muleHome) throws MojoExecutionException {
        try {
            this.copyZipFileToDestDirUsingTempFile(this.getMuleAppZipFile(), this.muleAppsDirectory(muleHome));
        }
        catch (IOException iox) {
            throw new MojoExecutionException("Exception while copying to apps directory", (Exception)iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyZipFileToDestDirUsingTempFile(File zipFile, File dest) throws IOException, MojoExecutionException {
        if (!dest.isDirectory()) {
            throw new IllegalArgumentException("destination must be a directory");
        }
        FileInputStream muleZipInput = null;
        FileOutputStream tempOutput = null;
        try {
            muleZipInput = new FileInputStream(zipFile);
            File tempFile = new File(dest, zipFile.getName().replace(".zip", ".temp"));
            tempOutput = new FileOutputStream(tempFile);
            IOUtil.copy((InputStream)muleZipInput, (OutputStream)tempOutput);
            this.getLog().info((CharSequence)String.format("Copying %1s to %2s", zipFile.getAbsolutePath(), tempFile.getAbsolutePath()));
            File finalFile = new File(dest, zipFile.getName());
            this.renameFile(tempFile, finalFile);
        }
        catch (Throwable throwable) {
            IOUtil.close(muleZipInput);
            IOUtil.close(tempOutput);
            throw throwable;
        }
        IOUtil.close((InputStream)muleZipInput);
        IOUtil.close((OutputStream)tempOutput);
    }

    public void renameFile(File orig, File dest) throws MojoExecutionException {
        try {
            Files.move(orig.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Could not rename %1s to %2s", orig.getAbsolutePath(), dest.getAbsolutePath()), (Exception)e);
        }
    }

    private File muleAppsDirectory(File muleHome) {
        return new File(muleHome, "apps");
    }
}

