/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.app;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.mule.tools.maven.plugin.MuleExportProperties;
import org.mule.tools.maven.plugin.ZipArchiver;
import org.mule.tools.maven.plugin.app.AbstractMuleMojo;

public class ProcessResources
extends AbstractMuleMojo {
    public static final String META_INF_FOLDER = "META-INF";
    public static final String[] BLACK_LIST = new String[]{".DS_STORE", "target"};
    private boolean attachMuleSources;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.attachMuleSources) {
            File metaInfFolder = this.createMetaInfFolderInTarget();
            File projectBaseFolder = this.project.getBasedir();
            this.generateExportedZipFile(metaInfFolder, projectBaseFolder);
            String projectName = projectBaseFolder.getName();
            this.generateMuleExportProperties(metaInfFolder, projectName);
        } else {
            this.getLog().info((CharSequence)"attachMuleSources default value is false, skipping process-resources goal...");
        }
    }

    private File createMetaInfFolderInTarget() {
        File targetFolder = new File(this.project.getBuild().getDirectory());
        File metaInfFolder = new File(targetFolder, META_INF_FOLDER);
        metaInfFolder.mkdir();
        return metaInfFolder;
    }

    protected void generateExportedZipFile(File metaInfFolder, File projectBaseFolder) throws MojoExecutionException {
        ZipArchiver archiver = this.getZipArchiver();
        String output = metaInfFolder.getAbsolutePath() + File.separator + projectBaseFolder.getName() + ".zip";
        try {
            archiver.toZip(projectBaseFolder, output);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create exportable zip file", (Exception)e);
        }
    }

    protected void generateMuleExportProperties(File metaInfFolder, String projectName) throws MojoExecutionException {
        MuleExportProperties exportProperties = new MuleExportProperties(projectName);
        try {
            exportProperties.store(metaInfFolder);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create mule_export.properties", (Exception)e);
        }
    }

    public ZipArchiver getZipArchiver() {
        return new ZipArchiver(BLACK_LIST);
    }
}

