/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.app;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.mule.tools.artifact.archiver.api.MuleApplicationArchiveBuilder;
import org.mule.tools.maven.plugin.app.AbstractMuleMojo;
import org.mule.tools.maven.plugin.app.ArtifactFilter;
import org.mule.tools.maven.plugin.app.Exclusion;
import org.mule.tools.maven.plugin.app.Inclusion;

public class MuleMojo
extends AbstractMuleMojo {
    public static final String LIB_LOCATION = "lib" + File.separator;
    private MavenProjectHelper projectHelper;
    private File classesDirectory;
    private boolean archiveClasses;
    private List<Exclusion> exclusions;
    private List<Inclusion> inclusions;
    private boolean excludeMuleDependencies;
    private boolean filterAppDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File app = this.getMuleAppZipFile();
        try {
            this.createMuleApp(app);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule App", (Exception)((Object)e));
        }
        this.projectHelper.attachArtifact(this.project, "zip", app);
    }

    protected void createMuleApp(File app) throws MojoExecutionException, ArchiverException {
        this.validateProject();
        MuleApplicationArchiveBuilder muleApplicationArchiveBuilder = new MuleApplicationArchiveBuilder();
        try {
            this.addAppDirectory(muleApplicationArchiveBuilder);
            this.addCompiledClasses(muleApplicationArchiveBuilder);
            this.addApiFiles(muleApplicationArchiveBuilder);
            this.addDependencies(muleApplicationArchiveBuilder);
            this.addMappingsDirectory(muleApplicationArchiveBuilder);
            this.addMetaInfDirectory(muleApplicationArchiveBuilder);
            muleApplicationArchiveBuilder.setDestinationFile(app);
            app.delete();
            muleApplicationArchiveBuilder.createDeployableFile();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot create archive", (Throwable)e);
        }
    }

    private void addMetaInfDirectory(MuleApplicationArchiveBuilder muleApplicationArchiveBuilder) {
        if (this.metaInfDirectory.exists()) {
            this.getLog().info((CharSequence)"Copying META-INF directly");
            this.addRecursively(this.metaInfDirectory, muleApplicationArchiveBuilder, "META-INF");
        } else {
            this.getLog().info((CharSequence)(this.metaInfDirectory + " does not exist, skipping"));
        }
    }

    private void addApiFiles(MuleApplicationArchiveBuilder muleApplicationArchiveBuilder) {
        if (this.apiDirectory.exists()) {
            this.getLog().info((CharSequence)"Copying api directly");
            this.addRecursively(this.apiDirectory, muleApplicationArchiveBuilder, "api");
        } else {
            this.getLog().info((CharSequence)(this.apiDirectory + " does not exist, skipping"));
        }
    }

    private void addRecursively(File directory, MuleApplicationArchiveBuilder muleApplicationArchiveBuilder, String path) {
        muleApplicationArchiveBuilder.addExtraResourceFolder(directory, path);
        if (directory != null && directory.listFiles() != null) {
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                this.addRecursively(file, muleApplicationArchiveBuilder, path + "/" + file.getName());
            }
        }
    }

    private void validateProject() throws MojoExecutionException {
        File muleConfig = new File(this.appDirectory, "mule-config.xml");
        File deploymentDescriptor = new File(this.appDirectory, "mule-deploy.properties");
        if (!muleConfig.exists() && !deploymentDescriptor.exists()) {
            String message = String.format("No mule-config.xml or mule-deploy.properties in %1s", this.project.getBasedir());
            this.getLog().error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
    }

    private void addAppDirectory(final MuleApplicationArchiveBuilder muleApplicationArchiveBuilder) throws ArchiverException, IOException {
        FileVisitor<Path> excludeFromClassesFolderFileVisitor = new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                muleApplicationArchiveBuilder.excludeFromClassesFolder(new File[]{file.toFile()});
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                muleApplicationArchiveBuilder.excludeFromClassesFolder(new File[]{dir.toFile()});
                return FileVisitResult.CONTINUE;
            }
        };
        if (this.filterAppDirectory) {
            muleApplicationArchiveBuilder.addRootResourcesFile(this.getFilteredAppDirectory());
            Files.walkFileTree(this.getFilteredAppDirectory().toPath(), (FileVisitor<? super Path>)excludeFromClassesFolderFileVisitor);
        } else {
            muleApplicationArchiveBuilder.addRootResourcesFile(this.appDirectory);
            Files.walkFileTree(this.appDirectory.toPath(), (FileVisitor<? super Path>)excludeFromClassesFolderFileVisitor);
        }
    }

    private void addCompiledClasses(MuleApplicationArchiveBuilder muleApplicationArchiveBuilder) throws ArchiverException, MojoExecutionException {
        if (!this.archiveClasses) {
            this.addClassesFolder(muleApplicationArchiveBuilder);
        } else {
            this.addArchivedClasses(muleApplicationArchiveBuilder);
        }
    }

    private void addClassesFolder(MuleApplicationArchiveBuilder muleApplicationArchiveBuilder) throws ArchiverException {
        if (this.classesDirectory.exists()) {
            this.getLog().info((CharSequence)"Copying classes directly");
            muleApplicationArchiveBuilder.addClassesFolder(this.classesDirectory);
        } else {
            this.getLog().info((CharSequence)(this.classesDirectory + " does not exist, skipping"));
        }
    }

    private void addMappingsDirectory(MuleApplicationArchiveBuilder muleApplicationArchiveBuilder) throws ArchiverException {
        if (this.mappingsDirectory.exists()) {
            this.getLog().info((CharSequence)"Copying mappings");
            muleApplicationArchiveBuilder.addResourcesFolder(this.mappingsDirectory);
        } else {
            this.getLog().info((CharSequence)(this.mappingsDirectory + " does not exist, skipping"));
        }
    }

    private void addArchivedClasses(MuleApplicationArchiveBuilder muleApplicationArchiveBuilder) throws ArchiverException, MojoExecutionException {
        if (!this.classesDirectory.exists()) {
            this.getLog().info((CharSequence)(this.classesDirectory + " does not exist, skipping"));
            return;
        }
        this.getLog().info((CharSequence)"Copying classes as a jar");
        JarArchiver jarArchiver = new JarArchiver();
        jarArchiver.addDirectory(this.classesDirectory, null, null);
        File jar = new File(this.outputDirectory, this.finalName + ".jar");
        jarArchiver.setDestFile(jar);
        try {
            jarArchiver.createArchive();
            muleApplicationArchiveBuilder.addJarLibrary(jar);
        }
        catch (IOException e) {
            String message = "Cannot create project jar";
            this.getLog().error((CharSequence)"Cannot create project jar", (Throwable)e);
            throw new MojoExecutionException("Cannot create project jar", (Exception)e);
        }
    }

    private void addDependencies(MuleApplicationArchiveBuilder muleApplicationArchiveBuilder) throws ArchiverException {
        for (Artifact artifact : this.getArtifactsToArchive()) {
            String message = String.format("Adding <%1s> as a lib", artifact.getId());
            this.getLog().info((CharSequence)message);
            muleApplicationArchiveBuilder.addJarLibrary(artifact.getFile());
        }
    }

    private Set<Artifact> getArtifactsToArchive() {
        ArtifactFilter filter = new ArtifactFilter(this.project, this.inclusions, this.exclusions, this.excludeMuleDependencies);
        return filter.getArtifactsToArchive();
    }
}

