/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.cloudhub;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.cloudhub.CloudHubClient;
import org.mule.tools.client.cloudhub.model.Application;
import org.mule.tools.client.cloudhub.model.MuleVersion;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.deployment.artifact.ArtifactDeployer;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.cloudhub.CloudHubDeploymentVerification;

public class CloudHubArtifactDeployer
implements ArtifactDeployer {
    private static final String DEFAULT_CH_REGION = "us-east-1";
    private static final Long DEFAULT_CLOUDHUB_DEPLOYMENT_TIMEOUT = 600000L;
    private final DeployerLog log;
    private final CloudHubDeployment deployment;
    private CloudHubClient client;
    private DeploymentVerification deploymentVerification;

    public CloudHubArtifactDeployer(Deployment deployment, DeployerLog log) {
        this(deployment, new CloudHubClient((CloudHubDeployment)deployment, log), log);
    }

    public CloudHubArtifactDeployer(Deployment deployment, CloudHubClient cloudHubClient, DeployerLog log) {
        Preconditions.checkArgument((cloudHubClient != null ? 1 : 0) != 0, (Object)"The Cloudhub client must not be null.");
        this.log = log;
        this.client = cloudHubClient;
        this.deploymentVerification = new CloudHubDeploymentVerification(this.client);
        this.deployment = (CloudHubDeployment)deployment;
        if (this.deployment.getDeploymentTimeout() == null) {
            this.deployment.setDeploymentTimeout(DEFAULT_CLOUDHUB_DEPLOYMENT_TIMEOUT);
        }
    }

    public void setDeploymentVerification(DeploymentVerification deploymentVerification) {
        Preconditions.checkArgument((deploymentVerification != null ? 1 : 0) != 0, (Object)"The verificator must not be null.");
        this.deploymentVerification = deploymentVerification;
    }

    @Override
    public void deployDomain() throws DeploymentException {
        throw new DeploymentException("Deployment of domains to CloudHub is not supported");
    }

    @Override
    public void undeployDomain() throws DeploymentException {
        throw new DeploymentException("Uneployment of domains from CloudHub is not supported");
    }

    @Override
    public void deployApplication() throws DeploymentException {
        this.createOrUpdateApplication();
        this.startApplication();
        this.checkApplicationHasStarted();
    }

    @Override
    public void undeployApplication() throws DeploymentException {
        this.log.info("Stopping application " + this.deployment.getApplicationName());
        this.client.stopApplications(this.deployment.getApplicationName());
    }

    public String getApplicationName() {
        return this.deployment.getApplicationName();
    }

    protected void createOrUpdateApplication() throws DeploymentException {
        if (this.client.isDomainAvailable(this.deployment.getApplicationName())) {
            this.createApplication();
        } else {
            this.updateApplication();
        }
    }

    protected void createApplication() {
        this.log.info("Creating application: " + this.deployment.getApplicationName());
        this.client.createApplications(this.getApplication(null), this.deployment.getArtifact());
    }

    protected void updateApplication() throws DeploymentException {
        Application currentApplication = this.client.getApplications(this.deployment.getApplicationName());
        if (currentApplication == null) {
            this.log.error("Application name: " + this.deployment.getApplicationName() + " is not available. Aborting.");
            throw new DeploymentException("Domain " + this.deployment.getApplicationName() + " is not available. Aborting.");
        }
        this.log.info("Application: " + this.deployment.getApplicationName() + " already exists, redeploying");
        this.client.updateApplications(this.getApplication(currentApplication), this.deployment.getArtifact());
    }

    protected void startApplication() {
        this.log.info("Starting application: " + this.deployment.getApplicationName());
        this.client.startApplications(this.deployment.getApplicationName());
    }

    protected void checkApplicationHasStarted() throws DeploymentException {
        this.log.info("Checking if application: " + this.deployment.getApplicationName() + " has started");
        this.deploymentVerification.assertDeployment(this.deployment);
    }

    private Application getApplication(Application originalApplication) {
        Application application = new Application();
        if (originalApplication != null) {
            application.setDomain(this.deployment.getApplicationName());
            MuleVersion muleVersion = new MuleVersion();
            muleVersion.setVersion(this.deployment.getMuleVersion());
            application.setMuleVersion(muleVersion);
            Map<String, String> properties = originalApplication.getProperties();
            properties.putAll(this.deployment.getProperties());
            application.setProperties(properties);
            if (StringUtils.isBlank((CharSequence)this.deployment.getRegion())) {
                application.setRegion(originalApplication.getRegion());
            } else {
                application.setRegion(this.deployment.getRegion());
            }
        } else {
            application.setDomain(this.deployment.getApplicationName());
            MuleVersion muleVersion = new MuleVersion();
            muleVersion.setVersion(this.deployment.getMuleVersion());
            application.setMuleVersion(muleVersion);
            application.setProperties(this.deployment.getProperties());
            String region = StringUtils.isBlank((CharSequence)this.deployment.getRegion()) ? DEFAULT_CH_REGION : this.deployment.getRegion();
            application.setRegion(region);
        }
        return application;
    }
}

