/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.validation.arm;

import org.mule.tools.client.arm.ArmClient;
import org.mule.tools.client.arm.model.Target;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.validation.AbstractDeploymentValidator;
import org.mule.tools.validation.EnvironmentSupportedVersions;

public class ArmDeploymentValidator
extends AbstractDeploymentValidator {
    public ArmDeploymentValidator(Deployment deployment) {
        super(deployment);
    }

    @Override
    public EnvironmentSupportedVersions getEnvironmentSupportedVersions() throws DeploymentException {
        ArmClient client = this.getArmClient();
        String muleRuntimeVersion = this.findRuntimeVersion(client);
        return new EnvironmentSupportedVersions(muleRuntimeVersion);
    }

    private String findRuntimeVersion(ArmClient client) {
        Target target = client.findServerByName(((ArmDeployment)this.deployment).getTarget());
        Integer serverId = Integer.valueOf(target.id);
        return client.getServer((Integer)serverId).data[0].muleVersion;
    }

    private ArmClient getArmClient() {
        ArmClient client = new ArmClient(this.deployment, null);
        return client;
    }
}

