/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.core;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.mule.tools.client.core.exception.ClientException;
import org.mule.tools.client.core.logging.ClientLoggingFilter;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractClient {
    private static final String USER_AGENT_MULE_DEPLOYER = "mule-deployer%s";
    protected DeployerLog log;
    private boolean isClientInitialized = false;

    public AbstractClient() {
    }

    public AbstractClient(DeployerLog log) {
        this.log = log;
    }

    protected Response post(String uri, String path, Entity entity) {
        this.initialize();
        return this.builder(uri, path).post(entity);
    }

    protected Response post(String uri, String path, Object entity) {
        this.initialize();
        return this.post(uri, path, Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response put(String uri, String path, Entity entity) {
        this.initialize();
        return this.builder(uri, path).put(entity);
    }

    protected Response put(String uri, String path, Object entity) {
        this.initialize();
        return this.put(uri, path, Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response delete(String uri, String path) {
        this.initialize();
        return this.builder(uri, path).delete();
    }

    protected Response get(String uri, String path) {
        this.initialize();
        return this.builder(uri, path).get();
    }

    protected <T> T get(String uri, String path, Class<T> clazz) {
        this.initialize();
        return (T)this.get(uri, path).readEntity(clazz);
    }

    protected Response patch(String uri, String path, Entity entity) {
        this.initialize();
        Invocation.Builder builder = this.builder(uri, path);
        builder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        return builder.method("PATCH", entity);
    }

    private synchronized void initialize() {
        if (!this.isClientInitialized) {
            this.isClientInitialized = true;
            this.init();
        }
    }

    protected abstract void init();

    private Invocation.Builder builder(String uri, String path) {
        WebTarget target = this.getTarget(uri, path);
        Invocation.Builder builder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.getUserAgent());
        this.configureRequest(builder);
        return builder;
    }

    protected WebTarget getTarget(String uri, String path) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        this.configureSecurityContext(builder);
        Client client = (Client)builder.build().register(MultiPartFeature.class);
        if (this.log != null && this.log.isDebugEnabled() && !this.isLoginRequest(path)) {
            client.register((Object)new ClientLoggingFilter(this.log));
        }
        return client.target(uri).path(path);
    }

    private boolean isLoginRequest(String path) {
        return "/accounts/login".equals(path);
    }

    protected String getUserAgent() {
        Package classPackage = AbstractClient.class.getPackage();
        String implementationVersion = classPackage != null ? classPackage.getImplementationVersion() : "";
        String version = StringUtils.isNotBlank((CharSequence)implementationVersion) ? "-[" + implementationVersion + "]" : "";
        return String.format(USER_AGENT_MULE_DEPLOYER, version);
    }

    protected void configureRequest(Invocation.Builder builder) {
    }

    protected void configureSecurityContext(ClientBuilder builder) {
    }

    protected void checkResponseStatus(Response response) {
        if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new ClientException(response);
        }
    }

    protected void checkResponseStatus(Response response, Response.Status ... expectedStatus) {
        ArrayList<Integer> success = new ArrayList<Integer>();
        for (Response.Status s : expectedStatus) {
            success.add(s.getStatusCode());
        }
        Integer statusCode = response.getStatus();
        if (!success.contains(statusCode)) {
            throw new ClientException(response);
        }
    }

    protected <T> T readJsonEntity(Response response, Type type) {
        String jsonResponse = (String)response.readEntity(String.class);
        return (T)new Gson().fromJson(jsonResponse, type);
    }
}

