/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.arm.model.Environment;
import org.mule.tools.client.arm.model.Environments;
import org.mule.tools.client.arm.model.Organization;
import org.mule.tools.client.arm.model.User;
import org.mule.tools.client.arm.model.UserInfo;
import org.mule.tools.client.authentication.AuthenticationServiceClient;
import org.mule.tools.client.authentication.model.Credentials;
import org.mule.tools.client.core.AbstractClient;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractMuleClient
extends AbstractClient {
    public static final String DEFAULT_BASE_URL = "https://anypoint.mulesoft.com";
    private static final String ENV_ID_HEADER = "X-ANYPNT-ENV-ID";
    private static final String ORG_ID_HEADER = "X-ANYPNT-ORG-ID";
    private static final String ME = "/accounts/api/me";
    private static final String ENVIRONMENTS = "/accounts/api/organizations/%s/environments";
    public static final String ORGANIZATION = "organization";
    public static final String SUB_ORGANIZATION_IDS = "subOrganizationIds";
    public static final String NAME = "name";
    public static final String USER = "user";
    public static final String ID = "id";
    protected String baseUri;
    private String bearerToken;
    private Credentials credentials;
    protected AuthenticationServiceClient authenticationServiceClient;
    private String envId;
    private String environmentName;
    private String orgId;
    private String businessGroupName;

    public AbstractMuleClient(AnypointDeployment anypointDeployment, DeployerLog log) {
        super(log);
        this.baseUri = anypointDeployment.getUri();
        this.credentials = new Credentials(anypointDeployment.getUsername(), anypointDeployment.getPassword());
        this.authenticationServiceClient = new AuthenticationServiceClient(this.baseUri);
        this.environmentName = anypointDeployment.getEnvironment();
        this.businessGroupName = anypointDeployment.getBusinessGroup();
    }

    @Override
    protected void init() {
        this.bearerToken = this.getBearerToken(this.credentials);
        this.orgId = this.getOrgId();
        this.envId = this.findEnvironmentByName((String)this.environmentName).id;
    }

    public String getEnvId() {
        return this.envId;
    }

    public UserInfo getMe() {
        String userInfoJsonString = this.get(this.baseUri, ME, String.class);
        JsonObject userInfoJson = (JsonObject)new JsonParser().parse(userInfoJsonString);
        Organization organization = this.buildOrganization(userInfoJson);
        User user = new User();
        user.organization = organization;
        UserInfo userInfo = new UserInfo();
        userInfo.user = user;
        return userInfo;
    }

    private Organization buildOrganization(JsonObject userInfoJson) {
        JsonObject organizationJson;
        JsonObject userJson;
        Organization organization = new Organization();
        if (userInfoJson != null && userInfoJson.has(USER) && (userJson = (JsonObject)userInfoJson.get(USER)) != null && userJson.has(ORGANIZATION) && (organizationJson = userJson.getAsJsonObject(ORGANIZATION)).has(ID) && organizationJson.has(NAME)) {
            organization.id = organizationJson.get(ID).getAsString();
            organization.name = organizationJson.get(NAME).getAsString();
            organization.subOrganizations = this.resolveSuborganizations(userJson, organizationJson);
        }
        return organization;
    }

    protected List<Organization> resolveSuborganizations(JsonObject userJson, JsonObject organizationJson) {
        ArrayList<Organization> suborganizations = new ArrayList<Organization>();
        if (organizationJson.has(SUB_ORGANIZATION_IDS)) {
            Set<String> ids = this.getSuborganizationIds(organizationJson);
            suborganizations.addAll(this.resolveAllSuborganizations(ids, userJson, "memberOfOrganizations"));
            suborganizations.addAll(this.resolveAllSuborganizations(ids, userJson, "contributorOfOrganizations"));
        }
        return suborganizations;
    }

    private List<Organization> resolveAllSuborganizations(Set<String> ids, JsonObject userJson, String organizationsDefinition) {
        JsonArray subOrganizationUserIsMemberOf;
        ArrayList<Organization> suborganizations = new ArrayList<Organization>();
        if (userJson.has(organizationsDefinition) && (subOrganizationUserIsMemberOf = userJson.get(organizationsDefinition).getAsJsonArray()) != null) {
            for (JsonElement org : subOrganizationUserIsMemberOf) {
                if (!org.isJsonObject()) continue;
                Organization suborganization = new Organization();
                suborganization.id = ((JsonObject)org).get(ID).getAsString();
                if (!ids.contains(suborganization.id)) continue;
                suborganization.name = ((JsonObject)org).get(NAME).getAsString();
                suborganizations.add(suborganization);
                ids.remove(suborganization.id);
            }
        }
        return suborganizations;
    }

    public Set<String> getSuborganizationIds(JsonObject organizationJson) {
        HashSet<String> suborganizationIds = new HashSet<String>();
        JsonArray subOrganizationIds = organizationJson.get(SUB_ORGANIZATION_IDS).getAsJsonArray();
        if (subOrganizationIds != null) {
            for (JsonElement id : subOrganizationIds) {
                suborganizationIds.add(id.getAsString());
            }
        }
        return suborganizationIds;
    }

    public String getOrgId() {
        return this.getBusinessGroupIdByBusinessGroupPath();
    }

    public Environment findEnvironmentByName(String name) {
        Environments response = this.get(this.baseUri, String.format(ENVIRONMENTS, this.orgId), Environments.class);
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find environmentName named [" + name + "]");
    }

    @Override
    protected void configureRequest(Invocation.Builder builder) {
        if (this.bearerToken != null) {
            builder.header("Authorization", (Object)("bearer " + this.bearerToken));
        }
        if (this.envId != null && this.orgId != null) {
            builder.header(ENV_ID_HEADER, (Object)this.envId);
            builder.header(ORG_ID_HEADER, (Object)this.orgId);
        }
    }

    protected String[] createBusinessGroupPath() {
        int i;
        if (StringUtils.isEmpty((CharSequence)this.businessGroupName)) {
            return new String[0];
        }
        ArrayList<String> groups = new ArrayList<String>();
        String group = "";
        for (i = 0; i < this.businessGroupName.length() - 1; ++i) {
            if (this.businessGroupName.charAt(i) == '\\') {
                if (this.businessGroupName.charAt(i + 1) == '\\') {
                    group = group + "\\";
                    ++i;
                    continue;
                }
                groups.add(group);
                group = "";
                continue;
            }
            group = group + this.businessGroupName.charAt(i);
        }
        if (i < this.businessGroupName.length()) {
            group = group + this.businessGroupName.charAt(this.businessGroupName.length() - 1);
        }
        groups.add(group);
        return groups.toArray(new String[0]);
    }

    private String getBusinessGroupIdByBusinessGroupPath() {
        String currentOrgId = null;
        Organization organizationHierarchy = this.getMe().user.organization;
        if (organizationHierarchy.subOrganizations == null || organizationHierarchy.subOrganizations.isEmpty()) {
            return organizationHierarchy.id;
        }
        List<Organization> subOrganizations = organizationHierarchy.subOrganizations;
        String[] groups = this.createBusinessGroupPath();
        if (groups.length == 0) {
            currentOrgId = organizationHierarchy.id;
        } else {
            block0: for (int group = 0; group < groups.length; ++group) {
                String groupName = groups[group];
                for (Organization o : subOrganizations) {
                    if (!o.name.equals(groupName)) continue;
                    currentOrgId = o.id;
                    subOrganizations = o.subOrganizations;
                    continue block0;
                }
            }
        }
        if (currentOrgId == null) {
            throw new ArrayIndexOutOfBoundsException("Cannot find business group.");
        }
        return currentOrgId;
    }

    private String getBearerToken(Credentials credentials) {
        if (StringUtils.isBlank((CharSequence)this.bearerToken)) {
            this.bearerToken = this.authenticationServiceClient.getBearerToken(credentials);
        }
        return this.bearerToken;
    }
}

