/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.verification;

import java.util.concurrent.TimeoutException;
import org.mule.tools.client.OperationRetrier;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.DeploymentVerificationStrategy;

public class DefaultDeploymentVerification
implements DeploymentVerification {
    private final OperationRetrier retrier;
    private final DeploymentVerificationStrategy verificationStrategy;

    public DefaultDeploymentVerification(DeploymentVerificationStrategy handler) {
        this(new OperationRetrier(), handler);
    }

    protected DefaultDeploymentVerification(OperationRetrier retrier, DeploymentVerificationStrategy verificationStrategy) {
        this.retrier = retrier;
        this.verificationStrategy = verificationStrategy;
    }

    @Override
    public void assertDeployment(Deployment deployment) throws DeploymentException {
        Long deploymentTimeout = deployment.getDeploymentTimeout();
        if (deploymentTimeout != null) {
            this.retrier.setTimeout(deploymentTimeout);
        }
        try {
            this.retrier.retry(this.verificationStrategy);
        }
        catch (InterruptedException | TimeoutException e) {
            this.verificationStrategy.onTimeout(deployment);
            throw new DeploymentException("Deployment has timed out", e);
        }
    }
}

