/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.validation.arm;

import java.util.ArrayList;
import java.util.List;
import org.mule.tools.client.arm.ArmClient;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.model.TargetType;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.validation.AbstractDeploymentValidator;
import org.mule.tools.validation.EnvironmentSupportedVersions;

public class ArmDeploymentValidator
extends AbstractDeploymentValidator {
    public ArmDeploymentValidator(Deployment deployment) {
        super(deployment);
    }

    @Override
    public EnvironmentSupportedVersions getEnvironmentSupportedVersions() throws DeploymentException {
        ArmClient client = this.getArmClient();
        List<String> muleRuntimeVersion = this.findRuntimeVersion(client);
        return new EnvironmentSupportedVersions(muleRuntimeVersion);
    }

    private List<String> findRuntimeVersion(ArmClient client) {
        TargetType targetType = ((ArmDeployment)this.deployment).getTargetType();
        ArrayList<String> runtimeVersions = new ArrayList<String>();
        if (TargetType.server.equals((Object)targetType)) {
            String id = client.getId(targetType, ((ArmDeployment)this.deployment).getTarget());
            Integer serverId = Integer.valueOf(id);
            runtimeVersions.add(client.getServer((Integer)serverId).data[0].muleVersion);
        } else {
            runtimeVersions.add(this.deployment.getMuleVersion());
        }
        return runtimeVersions;
    }

    private ArmClient getArmClient() {
        ArmClient client = new ArmClient(this.deployment, null);
        return client;
    }
}

