/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.verification.cloudhub;

import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.cloudhub.CloudHubClient;
import org.mule.tools.client.cloudhub.model.Application;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.verification.DefaultDeploymentVerification;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.DeploymentVerificationStrategy;

public class CloudHubDeploymentVerification
implements DeploymentVerification {
    private final CloudHubClient client;
    public static final String STARTED_STATUS = "STARTED";
    private static final String FAILED_STATUS = "FAILED";
    private static final String DEPLOYING_STATUS = "DEPLOYING";

    public CloudHubDeploymentVerification(CloudHubClient client) {
        this.client = client;
    }

    @Override
    public void assertDeployment(Deployment deployment) throws DeploymentException {
        DefaultDeploymentVerification verification = new DefaultDeploymentVerification(new CloudHubDeploymentVerificationStrategy(deployment));
        verification.assertDeployment(deployment);
    }

    private class CloudHubDeploymentVerificationStrategy
    implements DeploymentVerificationStrategy {
        private final Deployment deployment;

        public CloudHubDeploymentVerificationStrategy(Deployment deployment) {
            this.deployment = deployment;
        }

        @Override
        public Boolean isDeployed(Deployment deployment) {
            Application application = CloudHubDeploymentVerification.this.client.getApplications(deployment.getApplicationName());
            if (application != null) {
                if (StringUtils.containsIgnoreCase((CharSequence)application.getStatus(), (CharSequence)CloudHubDeploymentVerification.FAILED_STATUS)) {
                    throw new IllegalStateException("Deployment failed");
                }
                if (StringUtils.equals((CharSequence)CloudHubDeploymentVerification.STARTED_STATUS, (CharSequence)application.getStatus()) && !StringUtils.equals((CharSequence)CloudHubDeploymentVerification.DEPLOYING_STATUS, (CharSequence)application.getDeploymentUpdateStatus())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onTimeout(Deployment deployment) {
            CloudHubDeploymentVerification.this.client.stopApplications(deployment.getApplicationName());
        }

        @Override
        public Boolean run() {
            return this.isDeployed(this.deployment) == false;
        }

        @Override
        public String getRetryExhaustedMessage() {
            return "CloudHub deployment has timed out";
        }
    }
}

