/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.verification.fabric;

import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.fabric.RuntimeFabricClient;
import org.mule.tools.client.fabric.model.DeploymentDetailedResponse;
import org.mule.tools.client.fabric.model.DeploymentGenericResponse;
import org.mule.tools.client.fabric.model.Deployments;
import org.mule.tools.model.Deployment;
import org.mule.tools.verification.DefaultDeploymentVerification;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.DeploymentVerificationStrategy;

public class RuntimeFabricDeploymentVerification
implements DeploymentVerification {
    private final RuntimeFabricClient client;
    private static final String FAILED_STATUS = "FAILED";
    private static final String APPLIED_STATUS = "APPLIED";
    private static final String STARTED_STATUS = "STARTED";

    public RuntimeFabricDeploymentVerification(RuntimeFabricClient client) {
        this.client = client;
    }

    @Override
    public void assertDeployment(Deployment deployment) throws DeploymentException {
        DefaultDeploymentVerification verification = new DefaultDeploymentVerification(new RuntimeFabricDeploymentVerificationStrategy(deployment));
        verification.assertDeployment(deployment);
    }

    private class RuntimeFabricDeploymentVerificationStrategy
    implements DeploymentVerificationStrategy {
        private final Deployment deployment;
        private Deployments deployments;
        private String deploymentId;

        private RuntimeFabricDeploymentVerificationStrategy(Deployment deployment) {
            this.deployment = deployment;
            this.deployments = RuntimeFabricDeploymentVerification.this.client.getDeployments();
        }

        @Override
        public Boolean isDeployed(Deployment deployment) {
            String deploymentId = this.getDeploymentId(deployment);
            if (deploymentId == null) {
                return false;
            }
            DeploymentDetailedResponse response = RuntimeFabricDeploymentVerification.this.client.getDeployment(deploymentId);
            if (response != null) {
                if (StringUtils.equals((CharSequence)response.status, (CharSequence)RuntimeFabricDeploymentVerification.FAILED_STATUS)) {
                    throw new IllegalStateException("Deployment failed");
                }
                if (StringUtils.equals((CharSequence)response.status, (CharSequence)RuntimeFabricDeploymentVerification.APPLIED_STATUS) || StringUtils.equals((CharSequence)response.status, (CharSequence)RuntimeFabricDeploymentVerification.STARTED_STATUS)) {
                    return true;
                }
            }
            return false;
        }

        private String getDeploymentId(Deployment deployment) {
            if (this.deploymentId == null) {
                this.deployments = RuntimeFabricDeploymentVerification.this.client.getDeployments();
                for (DeploymentGenericResponse dep : this.deployments) {
                    if (!StringUtils.equals((CharSequence)dep.name, (CharSequence)deployment.getApplicationName())) continue;
                    this.deploymentId = dep.id;
                    return this.deploymentId;
                }
            }
            return this.deploymentId;
        }

        @Override
        public void onTimeout(Deployment deployment) {
        }

        @Override
        public Boolean run() {
            return this.isDeployed(this.deployment) == false;
        }

        @Override
        public String getRetryExhaustedMessage() {
            return "Runtime Fabric deployment has timed out";
        }
    }
}

