/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.agent;

import java.io.File;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.client.AbstractClient;
import org.mule.tools.client.exception.ClientException;

public class AgentClient
extends AbstractClient {
    public static final String APPLICATIONS_PATH = "/mule/applications/";
    private final String uri;

    public AgentClient(Log log, String uri) {
        super(log);
        this.uri = uri;
    }

    public void deployApplication(String applicationName, File file) {
        Response response = this.put(this.uri, APPLICATIONS_PATH + applicationName, Entity.entity((Object)file, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
        if (response.getStatus() != 202) {
            throw new ClientException(response, this.uri + APPLICATIONS_PATH + applicationName);
        }
    }

    public void undeployApplication(String appName) {
        Response response = this.delete(this.uri, APPLICATIONS_PATH + appName);
        if (response.getStatus() != 202) {
            throw new ClientException(response, this.uri + APPLICATIONS_PATH + appName);
        }
    }
}

