/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.cloudhub;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.mule.tools.client.AbstractMuleClient;
import org.mule.tools.client.cloudhub.Application;
import org.mule.tools.client.exception.ClientException;

public class CloudhubClient
extends AbstractMuleClient {
    public static final String APPLICATIONS_PATH = "/cloudhub/api/applications";
    public static final String APPLICATION_UPDATE_PATH = "/cloudhub/api/v2/applications/%s";
    public static final String APPLICATIONS_FILES_PATH = "/cloudhub/api/v2/applications/%s/files";
    public static final String DOMAINS_PATH = "/cloudhub/api/applications/domains/";
    public static final String CREATE_REQUEST_TEMPLATE = "{  \"domain\": \"%s\",  \"region\": \"%s\",  \"muleVersion\": \"%s\",  \"workers\": %d,  \"workerType\": \"%s\"";
    public static final String UPDATE_REQUEST_TEMPLATE = "{  \"region\":\"%s\",  \"muleVersion\": {\"version\": \"%s\"},  \"workers\": {    \"amount\": %d,    \"type\": {        \"name\": \"%s\"    }  }";

    public CloudhubClient(String uri, Log log, String username, String password, String environment, String businessGroup) {
        super(uri, log, username, password, environment, businessGroup);
    }

    public Application createApplication(String appName, String region, String muleVersion, Integer workers, String workerType, Map<String, String> properties) {
        Entity<String> json = this.createApplicationRequest(appName, region, muleVersion, workers, workerType, properties);
        Response response = this.post(this.uri, APPLICATIONS_PATH, json);
        if (response.getStatus() == 201) {
            return (Application)response.readEntity(Application.class);
        }
        throw new ClientException(response);
    }

    private Entity<String> createApplicationRequest(String appName, String region, String muleVersion, Integer workers, String workerType, Map<String, String> properties) {
        String json = String.format(CREATE_REQUEST_TEMPLATE, appName, region, muleVersion, workers, workerType);
        json = this.addProperties(properties, json);
        json = json + "}";
        return Entity.json((Object)json);
    }

    private Entity<String> updateApplicationRequest(String region, String muleVersion, Integer workers, String workerType, Map<String, String> properties) {
        String json = String.format(UPDATE_REQUEST_TEMPLATE, region, muleVersion, workers, workerType);
        json = this.addProperties(properties, json);
        json = json + "}";
        return Entity.json((Object)json);
    }

    private String addProperties(Map<String, String> properties, String json) {
        if (properties == null) {
            return json;
        }
        json = json + ",";
        json = json + "  \"properties\": {";
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            json = json + "    \"" + entry.getKey() + "\":\"" + entry.getValue() + "\",";
        }
        if (json.charAt(json.length() - 1) == ',') {
            json = json.substring(0, json.length() - 1);
        }
        json = json + "  }\n";
        return json;
    }

    public void updateApplication(String appName, String region, String muleVersion, Integer workers, String workerType, Map<String, String> properties) {
        Entity<String> json = this.updateApplicationRequest(region, muleVersion, workers, workerType, properties);
        Response response = this.put(this.uri, String.format(APPLICATION_UPDATE_PATH, appName), json);
        if (response.getStatus() != 200 && response.getStatus() != 301) {
            throw new ClientException(response);
        }
    }

    public Application getApplication(String appName) {
        Response response = this.get(this.uri, "/cloudhub/api/applications/" + appName);
        if (response.getStatus() == 200) {
            return (Application)response.readEntity(Application.class);
        }
        if (response.getStatus() == 404) {
            return null;
        }
        throw new ClientException(response);
    }

    public List<Application> getApplications() {
        Response response = this.get(this.uri, APPLICATIONS_PATH);
        if (response.getStatus() == 200) {
            return (List)response.readEntity((GenericType)new GenericType<List<Application>>(){});
        }
        throw new ClientException(response);
    }

    public void uploadFile(String appName, File file) {
        FileDataBodyPart applicationPart = new FileDataBodyPart("file", file);
        MultiPart multipart = new FormDataMultiPart().bodyPart((BodyPart)applicationPart);
        Response response = this.post(this.uri, String.format(APPLICATIONS_FILES_PATH, appName), Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        if (response.getStatus() != 200) {
            throw new ClientException(response);
        }
    }

    public void startApplication(String appName) {
        this.changeApplicationState(appName, "START");
    }

    public void stopApplication(String appName) {
        this.changeApplicationState(appName, "STOP");
    }

    private void changeApplicationState(String appName, String state) {
        Entity json = Entity.json((Object)("{\"status\": \"" + state + "\"}"));
        Response response = this.post(this.uri, "/cloudhub/api/applications/" + appName + "/status", json);
        if (response.getStatus() != 200 && response.getStatus() != 304) {
            throw new ClientException(response);
        }
    }

    public void deleteApplication(String appName) {
        Response response = this.delete(this.uri, "/cloudhub/api/applications/" + appName);
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            throw new ClientException(response);
        }
    }

    public boolean isNameAvailable(String appName) {
        Response response = this.get(this.uri, DOMAINS_PATH + appName);
        if (response.getStatus() == 200) {
            DomainAvailability availability = (DomainAvailability)response.readEntity(DomainAvailability.class);
            return availability.available;
        }
        throw new ClientException(response);
    }

    private static class DomainAvailability {
        public boolean available;

        private DomainAvailability() {
        }
    }
}

