/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.mule.tools.client.standalone.controller.MuleProcessController;

public class ClusterConfigurator {
    public boolean configureCluster(File[] paths, List<MuleProcessController> mules) throws MojoFailureException {
        int nodeNumber = 1;
        for (File f : paths) {
            try {
                if (!new File(f.getAbsolutePath() + "/.mule").mkdirs()) {
                    throw new MojoFailureException("Couldn't create .mule dir at: " + f.getAbsolutePath());
                }
                this.createClusterConfig(paths, mules, nodeNumber, f);
                ++nodeNumber;
            }
            catch (IOException ex) {
                throw new MojoFailureException("Couldn't create mule-cluster.properties in one of the mules" + ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClusterConfig(File[] paths, List<MuleProcessController> mules, int nodeNumber, File f) throws IOException, MojoFailureException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f.getAbsolutePath() + "/.mule/mule-cluster.properties"), StandardCharsets.UTF_8));
            writer.write("mule.clusterSize=" + paths.length);
            writer.write("mule.clusterSchema=partitioned-sync2backup");
            writer.write("mule.clusterId=" + mules.hashCode());
            writer.write("mule.clusterNodeId=" + nodeNumber);
            writer.close();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new MojoFailureException("Couldn't close mule-cluster.properties file: " + f.getAbsolutePath());
            }
        }
    }
}

