/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.deployment;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.mule.tools.client.standalone.controller.MuleProcessController;
import org.mule.tools.client.standalone.controller.probing.AppDeploymentProbe;
import org.mule.tools.client.standalone.controller.probing.PollingProber;
import org.mule.tools.client.standalone.controller.probing.Prober;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.client.standalone.exception.MuleControllerException;
import org.mule.tools.model.DeployerLog;
import org.mule.tools.model.DeploymentConfiguration;

public class StandaloneDeployer {
    private MuleProcessController mule;
    private DeployerLog log;
    private File application;
    private Prober prober;
    private Long timeout;
    private Long pollingDelay;
    private String[] arguments;

    public StandaloneDeployer(MuleProcessController mule, DeployerLog log, File application, Long timeout, String[] arguments, Long pollingDelay) {
        this.mule = mule;
        this.log = log;
        this.application = application;
        this.timeout = timeout;
        this.pollingDelay = pollingDelay;
        this.arguments = arguments;
        this.prober = new PollingProber(timeout, pollingDelay);
        log.debug(this.toString());
    }

    public String toString() {
        return String.format("StandaloneDeployer with [Controller=%s, log=%s, application=%s, timeout=%d, pollingDelay=%d ]", this.mule, this.log, this.application, this.timeout, this.pollingDelay);
    }

    public void execute() throws DeploymentException {
        try {
            this.verifyMuleIsStarted();
            this.deployApplications();
            this.waitForDeployments();
        }
        catch (MuleControllerException e) {
            throw new DeploymentException("Error deploying application: [" + this.application + "]: " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw new DeploymentException("Unexpected error deploying application: [" + this.application + "]", e);
        }
    }

    private void verifyMuleIsStarted() throws MuleControllerException {
        this.log.debug("Checking if Mule Runtime is running.");
        if (!this.mule.isRunning()) {
            throw new MuleControllerException("Mule Runtime is not running! Aborting.");
        }
    }

    private void waitForDeployments() throws DeploymentException {
        if (!this.application.exists()) {
            throw new DeploymentException("Application does not exists: " + this.application);
        }
        this.log.debug("Waiting for application [" + this.application + "] to be deployed.");
        String app = FilenameUtils.getBaseName((String)this.application.getName());
        try {
            this.prober.check(AppDeploymentProbe.isDeployed(this.mule, app));
        }
        catch (AssertionError e) {
            this.log.error("Couldn't deploy application [" + app + "] after [" + this.timeout + "] miliseconds. Check Mule Runtime log");
            throw new DeploymentException("Application deployment timeout.");
        }
    }

    private void deployApplications() throws DeploymentException {
        this.log.info("Deploying application [" + this.application + "]");
        try {
            this.mule.deploy(this.application.getAbsolutePath());
        }
        catch (MuleControllerException e) {
            throw new DeploymentException("Couldn't deploy application: " + this.application + ". Check Mule Runtime logs");
        }
    }

    private void startMuleIfStopped() {
        this.log.debug("Checking if Mule Runtime is running.");
        if (!this.mule.isRunning()) {
            try {
                this.log.info("Starting Mule Runtime");
                if (this.arguments == null) {
                    this.mule.start(new String[0]);
                } else {
                    this.mule.start(this.arguments);
                }
            }
            catch (MuleControllerException e) {
                this.log.error("Couldn't start Mule Runtime. Check Mule Runtime logs.");
            }
        }
    }

    public StandaloneDeployer addLibraries(List<File> libs) {
        Preconditions.checkNotNull(libs, (Object)"Libraries cannot be null");
        for (File file : libs) {
            this.mule.addLibrary(file);
            this.log.debug(String.format("Adding library %s...", file));
        }
        return this;
    }

    public StandaloneDeployer addDomain(File domain) throws DeploymentException {
        Preconditions.checkNotNull((Object)domain, (Object)"Domain cannot be null");
        try {
            this.log.debug(String.format("Deploying domain : %s", domain));
            this.mule.deployDomain(domain.getAbsolutePath());
            return this;
        }
        catch (MuleControllerException e) {
            this.log.error("Couldn't deploy domain: " + domain);
            throw new DeploymentException("Couldn't deploy domain: " + domain);
        }
    }

    public void addDomainFromDeploymentConfiguration(DeploymentConfiguration configuration) throws DeploymentException {
        if (configuration.getDomain() != null && configuration.getDomain().exists()) {
            this.log.debug("Adding domain with configuration: " + configuration.getDomain());
            this.addDomain(configuration.getDomain());
        } else {
            this.log.debug("Domain configuration not found: " + configuration.getDomain());
        }
    }
}

