/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.installer;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.mule.tools.model.ArtifactDescription;
import org.mule.tools.model.DeploymentConfiguration;

public class MuleStandaloneInstaller {
    private DeploymentConfiguration deploymentConfiguration;
    private MavenProject mavenProject;
    private ArtifactResolver artifactResolver;
    private ArchiverManager archiverManager;
    private ArtifactFactory artifactFactory;
    private Log log;
    private ArtifactRepository localRepository;

    public MuleStandaloneInstaller(DeploymentConfiguration deploymentConfiguration, MavenProject mavenProject, ArtifactResolver artifactResolver, ArchiverManager archiverManager, ArtifactFactory artifactFactory, ArtifactRepository localRepository, Log log) {
        this.deploymentConfiguration = deploymentConfiguration;
        this.mavenProject = mavenProject;
        this.artifactResolver = artifactResolver;
        this.archiverManager = archiverManager;
        this.artifactFactory = artifactFactory;
        this.localRepository = localRepository;
        this.log = log;
    }

    public File installMule(File buildDirectory) throws MojoExecutionException, MojoFailureException {
        if (this.deploymentConfiguration.getMuleHome() == null) {
            this.deploymentConfiguration.setMuleHome(this.doInstallMule(buildDirectory));
        }
        this.mavenProject.getProperties().setProperty("mule.home", this.deploymentConfiguration.getMuleHome().getAbsolutePath());
        this.log.info((CharSequence)("Using MULE_HOME: " + this.deploymentConfiguration.getMuleHome()));
        return this.deploymentConfiguration.getMuleHome();
    }

    public File doInstallMule(File buildDirectory) throws MojoExecutionException, MojoFailureException {
        if (this.deploymentConfiguration.getMuleDistribution() == null) {
            if (this.deploymentConfiguration.isCommunity()) {
                this.deploymentConfiguration.setMuleDistribution(new ArtifactDescription("org.mule.distributions", "mule-standalone", this.deploymentConfiguration.getMuleVersion(), "tar.gz"));
                this.log.debug((CharSequence)("muleDistribution not set, using default community artifact: " + this.deploymentConfiguration.getMuleDistribution()));
            } else {
                this.deploymentConfiguration.setMuleDistribution(new ArtifactDescription("com.mulesoft.mule.distributions", "mule-ee-distribution-standalone", this.deploymentConfiguration.getMuleVersion(), "tar.gz"));
                this.log.debug((CharSequence)("muleDistribution not set, using default artifact: " + this.deploymentConfiguration.getMuleDistribution()));
            }
        }
        this.unpackMule(this.deploymentConfiguration.getMuleDistribution(), buildDirectory);
        String contentDirectory = this.resolveMuleContentDirectory(this.deploymentConfiguration.getMuleDistribution());
        return new File(buildDirectory, contentDirectory);
    }

    private String resolveMuleContentDirectory(ArtifactDescription muleDistribution) {
        return "mule-" + ("mule-standalone".equals(muleDistribution.getArtifactId()) ? "" : "enterprise-") + "standalone-" + muleDistribution.getVersion();
    }

    public void unpackMule(ArtifactDescription muleDistribution, File destDir) throws MojoExecutionException, MojoFailureException {
        File src = this.getDependency(muleDistribution);
        this.log.info((CharSequence)("Copying " + src.getAbsolutePath() + " to " + destDir.getAbsolutePath()));
        this.extract(src, destDir, muleDistribution.getType());
    }

    private void extract(File src, File dest, String type) throws MojoExecutionException, MojoFailureException {
        try {
            UnArchiver unArchiver = this.getArchiver(type);
            unArchiver.setSourceFile(src);
            unArchiver.setDestDirectory(dest);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Couldn't extract file " + src + " to " + dest);
        }
        catch (Exception e) {
            throw new MojoFailureException("Couldn't extract file " + src + " to " + dest);
        }
    }

    private UnArchiver getArchiver(String type) throws MojoExecutionException {
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(type);
            this.log.debug((CharSequence)("Found unArchiver by extension: " + unArchiver));
            return unArchiver;
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Couldn't find archiver for type: " + type);
        }
    }

    protected File getDependency(ArtifactDescription artifactDescription) throws MojoExecutionException, MojoFailureException {
        try {
            Artifact artifact = this.artifactFactory.createArtifact(artifactDescription.getGroupId(), artifactDescription.getArtifactId(), artifactDescription.getVersion(), null, artifactDescription.getType());
            this.log.info((CharSequence)("Resolving " + artifact));
            this.artifactResolver.resolve(artifact, this.mavenProject.getRemoteArtifactRepositories(), this.localRepository);
            return artifact.getFile();
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoFailureException("Couldn't download artifact: " + e.getMessage());
        }
    }
}

