/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class ArtifactDescription {
    private final String COORDINATES_SEPARATOR = ":";
    private String groupId;
    private String artifactId;
    private String version;
    private String type;

    public ArtifactDescription() {
    }

    public ArtifactDescription(String artifactCoordinates) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)artifactCoordinates), (Object)"The artifact coordinates must not be null nor empty");
        String[] coordinateElements = artifactCoordinates.split(":");
        Preconditions.checkState((coordinateElements.length == 4 ? 1 : 0) != 0, (Object)"The artifact coordinates are not in the format groupId:artifactId:version:type");
        this.setGroupId(coordinateElements[0]);
        this.setArtifactId(coordinateElements[1]);
        this.setVersion(coordinateElements[2]);
        this.setType(coordinateElements[3]);
    }

    public ArtifactDescription(String groupId, String artifactId, String version, String type) {
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
        this.setType(type);
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", this.groupId, this.artifactId, this.version, this.type);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)groupId), (Object)"The groupId must not be null nor empty");
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)artifactId), (Object)"The artifactId must not be null nor empty");
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)version), (Object)"The version must not be null nor empty");
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.version), (Object)"The type must not be null nor empty");
        this.type = type;
    }
}

