/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.model;

import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.mule.tools.model.DeployerLog;
import org.mule.tools.model.DeploymentConfiguration;

public class DeploymentConfigurator {
    private final DeployerLog log;
    private DeploymentConfiguration configuration;

    public DeploymentConfigurator(DeploymentConfiguration configuration, DeployerLog log) {
        this.configuration = configuration;
        this.log = log;
    }

    public void initializeApplication(ArtifactFactory factory, MavenProject project, ArtifactResolver resolver, ArtifactRepository localRepository) throws MojoFailureException {
        if (this.configuration.getApplication() == null) {
            Artifact artifact = this.resolveMavenProjectArtifact(factory, project, resolver, localRepository);
            this.configuration.setApplication(artifact.getFile());
            this.log.info("No application configured. Using project artifact: " + this.configuration.getApplication());
            if (this.configuration.getApplicationName() == null) {
                this.configuration.setApplicationName(artifact.getArtifactId());
            }
        } else if (StringUtils.isBlank((CharSequence)this.configuration.getApplicationName())) {
            this.configuration.setApplicationName(this.configuration.getApplication().getName());
        }
    }

    protected Artifact resolveMavenProjectArtifact(ArtifactFactory factory, MavenProject project, ArtifactResolver resolver, ArtifactRepository localRepository) throws MojoFailureException {
        Artifact artifact = factory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "jar", project.getPackaging());
        try {
            resolver.resolve(artifact, new ArrayList(), localRepository);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            throw new MojoFailureException("Couldn't resolve artifact [" + artifact + "]");
        }
        return artifact;
    }

    public void initializeEnvironment(Settings settings, SettingsDecrypter decrypter) throws MojoExecutionException {
        String ibmJdkSupport;
        if (this.configuration.getServer() != null) {
            Server serverObject = settings.getServer(this.configuration.getServer());
            if (serverObject == null) {
                this.log.error("Server [" + this.configuration.getServer() + "] not found in settings file.");
                throw new MojoExecutionException("Server [" + this.configuration.getServer() + "] not found in settings file.");
            }
            serverObject = decrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(serverObject)).getServer();
            if (StringUtils.isNotEmpty((CharSequence)this.configuration.getUsername()) || StringUtils.isNotEmpty((CharSequence)this.configuration.getPassword())) {
                this.log.warn("Both server and credentials are configured. Using plugin configuration credentials.");
            } else {
                this.configuration.setUsername(serverObject.getUsername());
                this.configuration.setPassword(serverObject.getPassword());
            }
        }
        if ("true".equals(ibmJdkSupport = System.getProperty("ibm.jdk.support"))) {
            this.log.debug("Attempting to provide support for IBM JDK...");
            try {
                Field methods = HttpURLConnection.class.getDeclaredField("methods");
                methods.setAccessible(true);
                Field modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
                modifiers.setInt(methods, methods.getModifiers() & 0xFFFFFFEF);
                String[] actualMethods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "PATCH", "DELETE", "TRACE"};
                methods.set(null, actualMethods);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.log.error("Fail to provide support for IBM JDK", e);
            }
        }
    }
}

