/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.agent;

import groovy.util.ScriptException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.agent.AgentClient;
import org.mule.tools.client.exception.ClientException;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.utils.DeployerLog;

public class AgentDeployer
extends AbstractDeployer {
    private AgentDeployment agentDeployment;
    private AgentClient agentClient;

    public AgentDeployer(AgentDeployment agentDeployment, DeployerLog log) throws DeploymentException {
        super(agentDeployment, log);
    }

    @Override
    public void deploy() throws DeploymentException {
        try {
            this.info("Deploying application " + this.getApplicationName() + " to Mule Agent");
            this.agentClient.deployApplication(this.getApplicationName(), this.getApplicationFile());
        }
        catch (ClientException e) {
            this.error("Failure: " + e.getMessage());
            throw new DeploymentException("Failed to deploy application " + this.getApplicationName(), e);
        }
    }

    @Override
    public void undeploy(MavenProject mavenProject) throws DeploymentException {
        AgentClient agentClient = new AgentClient(this.log, this.agentDeployment.getUri());
        this.log.info("Undeploying application " + this.agentDeployment.getApplicationName());
        agentClient.undeployApplication(this.agentDeployment.getApplicationName());
    }

    @Override
    protected void initialize() {
        this.agentDeployment = (AgentDeployment)this.deploymentConfiguration;
        this.agentClient = new AgentClient(this.log, this.agentDeployment.getUri());
    }

    @Override
    public void resolveDependencies(MavenProject mavenProject, ArtifactResolver artifactResolver, ArchiverManager archiverManager, ArtifactFactory artifactFactory, ArtifactRepository localRepository) throws DeploymentException, ScriptException {
    }
}

