/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.deployment;

import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.eclipse.aether.deployment.DeploymentException;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.standalone.configuration.ClusterConfigurator;
import org.mule.tools.client.standalone.controller.MuleProcessController;
import org.mule.tools.client.standalone.controller.probing.AppDeploymentProbe;
import org.mule.tools.client.standalone.controller.probing.PollingProber;
import org.mule.tools.client.standalone.deployment.StandaloneUndeployer;
import org.mule.tools.client.standalone.exception.MuleControllerException;
import org.mule.tools.client.standalone.installer.MuleStandaloneInstaller;
import org.mule.tools.model.standalone.ClusterDeployment;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.utils.GroovyUtils;

public class ClusterDeployer
extends AbstractDeployer {
    public static final double MAX_CLUSTER_SIZE = 8.0;
    public static final long DEFAULT_POLLING_DELAY = 1000L;
    private final ClusterDeployment clusterDeployment;
    private List<MuleProcessController> mules;
    private File[] paths;
    private ClusterConfigurator configurator = new ClusterConfigurator();

    public ClusterDeployer(ClusterDeployment clusterDeployment, DeployerLog log) throws org.mule.tools.client.standalone.exception.DeploymentException {
        super(clusterDeployment, log);
        this.clusterDeployment = clusterDeployment;
    }

    public String toString() {
        return String.format("StandaloneDeployer with [Controllers=%s, log=%s, application=%s, timeout=%d, pollingDelay=%d ]", this.mules, this.log, this.clusterDeployment.getArtifact(), this.clusterDeployment.getDeploymentTimeout(), 1000L);
    }

    private void waitForDeployments() throws org.mule.tools.client.standalone.exception.DeploymentException {
        for (MuleProcessController m : this.mules) {
            if (!this.clusterDeployment.getArtifact().exists()) {
                throw new org.mule.tools.client.standalone.exception.DeploymentException("Application does not exists: " + this.clusterDeployment.getArtifact());
            }
            this.log.debug("Checking for application [" + this.clusterDeployment.getArtifact() + "] to be deployed.");
            String app = this.getApplicationName(this.clusterDeployment.getArtifact());
            try {
                new PollingProber(this.clusterDeployment.getDeploymentTimeout(), 1000L).check(AppDeploymentProbe.isDeployed(m, app));
            }
            catch (AssertionError e) {
                this.log.error("Couldn't deploy application [" + this.clusterDeployment.getArtifact() + "] after [" + this.clusterDeployment.getDeploymentTimeout() + "] miliseconds. Check Mule Runtime log");
                throw new org.mule.tools.client.standalone.exception.DeploymentException("Application deployment timeout.");
            }
        }
    }

    private String getApplicationName(File application) {
        String name = application.getName();
        int extensionBeginning = name.lastIndexOf(46);
        return extensionBeginning == -1 ? name : name.substring(0, extensionBeginning);
    }

    private void deployApplications() throws org.mule.tools.client.standalone.exception.DeploymentException {
        for (MuleProcessController m : this.mules) {
            if (!this.clusterDeployment.getArtifact().exists()) {
                throw new org.mule.tools.client.standalone.exception.DeploymentException("Application does not exists: " + this.clusterDeployment.getArtifact().getAbsolutePath());
            }
            this.log.info("Deploying application [" + this.clusterDeployment.getArtifact() + "]");
            try {
                m.deploy(this.clusterDeployment.getArtifact().getAbsolutePath());
            }
            catch (MuleControllerException e) {
                this.log.error("Couldn't deploy application: " + this.clusterDeployment.getArtifact() + ". Check Mule Runtime logs");
            }
        }
    }

    private void startMulesIfStopped() {
        for (MuleProcessController m : this.mules) {
            this.log.debug("Checking if Mule Runtime is running.");
            if (m.isRunning()) continue;
            try {
                this.log.info("Starting Mule Runtime");
                if (this.clusterDeployment.getArguments() == null) {
                    m.start(new String[0]);
                    continue;
                }
                m.start(this.clusterDeployment.getArguments());
            }
            catch (MuleControllerException e) {
                this.log.error("Couldn't start Mule Runtime. Check Mule Runtime logs");
            }
        }
    }

    @Override
    public void deploy() throws org.mule.tools.client.standalone.exception.DeploymentException {
        try {
            this.configurator.configureCluster(this.paths, this.mules);
            this.startMulesIfStopped();
            this.deployApplications();
            this.waitForDeployments();
        }
        catch (MuleControllerException e) {
            throw new org.mule.tools.client.standalone.exception.DeploymentException("Error deploying application: [" + this.clusterDeployment.getArtifact() + "]");
        }
        catch (RuntimeException e) {
            throw new org.mule.tools.client.standalone.exception.DeploymentException("Unexpected error deploying application: [" + this.clusterDeployment.getArtifact() + "]", e);
        }
    }

    @Override
    public void undeploy(MavenProject mavenProject) throws org.mule.tools.client.standalone.exception.DeploymentException {
        File[] muleHomes = new File[this.clusterDeployment.getSize().intValue()];
        for (int i = 0; i < this.clusterDeployment.getSize(); ++i) {
            File parentDir = new File(mavenProject.getBuild().getDirectory(), "mule" + i);
            muleHomes[i] = new File(parentDir, "mule-enterprise-standalone-" + this.clusterDeployment.getMuleVersion());
            if (muleHomes[i].exists()) continue;
            throw new org.mule.tools.client.standalone.exception.DeploymentException(muleHomes[i].getAbsolutePath() + "directory does not exist.");
        }
        new StandaloneUndeployer(this.log, this.clusterDeployment.getApplicationName(), muleHomes).execute();
    }

    @Override
    protected void initialize() throws org.mule.tools.client.standalone.exception.DeploymentException {
        this.validateSize();
        this.renameApplicationToApplicationName();
    }

    @Override
    public void resolveDependencies(MavenProject mavenProject, ArtifactResolver artifactResolver, ArchiverManager archiverManager, ArtifactFactory artifactFactory, ArtifactRepository localRepository) throws org.mule.tools.client.standalone.exception.DeploymentException, ScriptException {
        this.paths = new File[this.clusterDeployment.getSize().intValue()];
        LinkedList<MuleProcessController> controllers = new LinkedList<MuleProcessController>();
        for (int i = 0; i < this.clusterDeployment.getSize(); ++i) {
            File buildDirectory = new File(mavenProject.getBuild().getDirectory(), "mule" + i);
            buildDirectory.mkdir();
            File home = null;
            try {
                new MuleStandaloneInstaller(this.clusterDeployment, mavenProject, artifactResolver, archiverManager, artifactFactory, localRepository, this.log).doInstallMule(buildDirectory);
            }
            catch (DeploymentException e) {
                throw new org.mule.tools.client.standalone.exception.DeploymentException("Could not install mule standalone. Aborting.", e);
            }
            controllers.add(new MuleProcessController(home.getAbsolutePath(), this.clusterDeployment.getTimeout()));
            this.paths[i] = home;
        }
        if (null != this.clusterDeployment.getScript()) {
            GroovyUtils.executeScript(mavenProject, this.clusterDeployment.getScript());
        }
    }

    private void validateSize() throws org.mule.tools.client.standalone.exception.DeploymentException {
        if ((double)this.clusterDeployment.getSize().intValue() > 8.0) {
            throw new org.mule.tools.client.standalone.exception.DeploymentException("Cannot create cluster with more than 8 nodes");
        }
    }

    private void renameApplicationToApplicationName() throws org.mule.tools.client.standalone.exception.DeploymentException {
        if (!FilenameUtils.getBaseName((String)this.clusterDeployment.getArtifact().getName()).equals(this.clusterDeployment.getApplicationName())) {
            try {
                File destApplication = new File(this.clusterDeployment.getArtifact().getParentFile(), this.clusterDeployment.getApplicationName() + ".jar");
                FileUtils.copyFile((File)this.clusterDeployment.getArtifact(), (File)destApplication);
                this.clusterDeployment.setArtifact(destApplication);
            }
            catch (IOException e) {
                throw new org.mule.tools.client.standalone.exception.DeploymentException("Couldn't rename [" + this.clusterDeployment.getArtifact() + "] to [" + this.clusterDeployment.getApplicationName() + "]");
            }
        }
    }
}

