/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.deployment;

import com.google.common.base.Preconditions;
import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.standalone.controller.MuleProcessController;
import org.mule.tools.client.standalone.controller.probing.AppDeploymentProbe;
import org.mule.tools.client.standalone.controller.probing.PollingProber;
import org.mule.tools.client.standalone.controller.probing.Prober;
import org.mule.tools.client.standalone.deployment.StandaloneUndeployer;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.client.standalone.exception.MuleControllerException;
import org.mule.tools.model.standalone.StandaloneDeployment;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.utils.GroovyUtils;

public class StandaloneDeployer
extends AbstractDeployer {
    private static final long DEFAULT_POLLING_DELAY = 1000L;
    private StandaloneDeployment standaloneDeployment;
    private MuleProcessController mule;
    private Prober prober;

    public StandaloneDeployer(StandaloneDeployment standaloneDeployment, DeployerLog log) throws DeploymentException {
        super(standaloneDeployment, log);
    }

    public String toString() {
        return String.format("StandaloneDeployer with [Controller=%s, log=%s, application=%s, timeout=%d, pollingDelay=%d ]", this.mule, this.log, this.standaloneDeployment.getArtifact(), this.standaloneDeployment.getDeploymentTimeout(), 1000L);
    }

    private void verifyMuleIsStarted() throws MuleControllerException {
        this.log.debug("Checking if Mule Runtime is running.");
        if (!this.mule.isRunning()) {
            throw new MuleControllerException("Mule Runtime is not running! Aborting.");
        }
    }

    private void waitForDeployments() throws DeploymentException {
        if (!this.standaloneDeployment.getArtifact().exists()) {
            throw new DeploymentException("Application does not exists: " + this.standaloneDeployment.getArtifact());
        }
        this.log.debug("Waiting for application [" + this.standaloneDeployment.getArtifact() + "] to be deployed.");
        String app = FilenameUtils.getBaseName((String)this.standaloneDeployment.getArtifact().getName());
        try {
            this.prober.check(AppDeploymentProbe.isDeployed(this.mule, app));
        }
        catch (AssertionError e) {
            this.log.error("Couldn't deploy application [" + app + "] after [" + this.standaloneDeployment.getDeploymentTimeout() + "] miliseconds. Check Mule Runtime log");
            throw new DeploymentException("Application deployment timeout.");
        }
    }

    private void deployApplications() throws DeploymentException {
        this.log.info("Deploying application [" + this.standaloneDeployment.getArtifact() + "]");
        try {
            this.mule.deploy(this.standaloneDeployment.getArtifact().getAbsolutePath());
        }
        catch (MuleControllerException e) {
            throw new DeploymentException("Couldn't deploy application: " + this.standaloneDeployment.getArtifact() + ". Check Mule Runtime logs");
        }
    }

    private void startMuleIfStopped() {
        this.log.debug("Checking if Mule Runtime is running.");
        if (!this.mule.isRunning()) {
            try {
                this.log.info("Starting Mule Runtime");
                if (this.standaloneDeployment.getArguments() == null) {
                    this.mule.start(new String[0]);
                } else {
                    this.mule.start(this.standaloneDeployment.getArguments());
                }
            }
            catch (MuleControllerException e) {
                this.log.error("Couldn't start Mule Runtime. Check Mule Runtime logs.");
            }
        }
    }

    public StandaloneDeployer addLibraries(List<File> libs) {
        Preconditions.checkNotNull(libs, (Object)"Libraries cannot be null");
        for (File file : libs) {
            this.mule.addLibrary(file);
            this.log.debug(String.format("Adding library %s...", file));
        }
        return this;
    }

    public StandaloneDeployer addDomain(File domain) throws DeploymentException {
        Preconditions.checkNotNull((Object)domain, (Object)"Domain cannot be null");
        try {
            this.log.debug(String.format("Deploying domain : %s", domain));
            this.mule.deployDomain(domain.getAbsolutePath());
            return this;
        }
        catch (MuleControllerException e) {
            this.log.error("Couldn't deploy domain: " + domain);
            throw new DeploymentException("Couldn't deploy domain: " + domain);
        }
    }

    public void addDomainFromstandaloneDeployment(StandaloneDeployment configuration) throws DeploymentException {
        if (configuration.getDomain() != null && configuration.getDomain().exists()) {
            this.log.debug("Adding domain with configuration: " + configuration.getDomain());
            this.addDomain(configuration.getDomain());
        } else {
            this.log.debug("Domain configuration not found: " + configuration.getDomain());
        }
    }

    @Override
    public void deploy() throws DeploymentException {
        try {
            this.verifyMuleIsStarted();
            this.deployApplications();
            this.waitForDeployments();
        }
        catch (MuleControllerException e) {
            throw new DeploymentException("Error deploying application: [" + this.standaloneDeployment.getArtifact() + "]: " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw new DeploymentException("Unexpected error deploying application: [" + this.standaloneDeployment.getArtifact() + "]", e);
        }
    }

    @Override
    public void undeploy(MavenProject mavenProject) throws DeploymentException {
        if (!this.standaloneDeployment.getMuleHome().exists()) {
            throw new DeploymentException("MULE_HOME directory does not exist.");
        }
        this.log.info("Using MULE_HOME: " + this.standaloneDeployment.getMuleHome());
        new StandaloneUndeployer(this.log, this.standaloneDeployment.getApplicationName(), this.standaloneDeployment.getMuleHome()).execute();
    }

    @Override
    protected void initialize() throws DeploymentException {
        this.standaloneDeployment = (StandaloneDeployment)this.deploymentConfiguration;
        this.mule = new MuleProcessController(this.standaloneDeployment.getMuleHome().getAbsolutePath(), this.standaloneDeployment.getTimeout());
        this.renameApplicationToApplicationName();
        this.prober = new PollingProber(this.standaloneDeployment.getDeploymentTimeout(), 1000L);
        this.addDomainFromstandaloneDeployment(this.standaloneDeployment);
    }

    @Override
    public void resolveDependencies(MavenProject mavenProject, ArtifactResolver artifactResolver, ArchiverManager archiverManager, ArtifactFactory artifactFactory, ArtifactRepository localRepository) throws DeploymentException, ScriptException {
        List<File> libs = this.getDependencies(this.standaloneDeployment, artifactFactory, artifactResolver, mavenProject, localRepository);
        this.addLibraries(libs);
        if (null != this.standaloneDeployment.getScript()) {
            GroovyUtils.executeScript(mavenProject, this.standaloneDeployment.getScript());
        }
    }

    private void renameApplicationToApplicationName() throws DeploymentException {
        if (!FilenameUtils.getBaseName((String)this.standaloneDeployment.getArtifact().getName()).equals(this.standaloneDeployment.getApplicationName())) {
            try {
                File destApplication = new File(this.standaloneDeployment.getArtifact().getParentFile(), this.standaloneDeployment.getApplicationName() + ".jar");
                FileUtils.copyFile((File)this.standaloneDeployment.getArtifact(), (File)destApplication);
                this.standaloneDeployment.setArtifact(destApplication);
            }
            catch (IOException e) {
                throw new DeploymentException("Fail to rename [" + this.standaloneDeployment.getArtifact() + "] to [" + this.standaloneDeployment.getApplicationName() + "]");
            }
        }
    }

    public List<File> getDependencies(StandaloneDeployment standaloneDeployment, ArtifactFactory factory, ArtifactResolver resolver, MavenProject project, ArtifactRepository repository) throws DeploymentException {
        ArrayList<File> libraries = new ArrayList<File>();
        for (ArtifactCoordinates artifact : standaloneDeployment.getArtifactItems()) {
            libraries.add(this.getDependency(artifact, factory, resolver, project, repository));
        }
        return libraries;
    }

    protected File getDependency(ArtifactCoordinates artifactDescription, ArtifactFactory factory, ArtifactResolver resolver, MavenProject project, ArtifactRepository repository) throws DeploymentException {
        try {
            Artifact artifact = factory.createArtifact(artifactDescription.getGroupId(), artifactDescription.getArtifactId(), artifactDescription.getVersion(), null, artifactDescription.getType());
            this.log.info("Resolving " + artifact);
            resolver.resolve(artifact, project.getRemoteArtifactRepositories(), repository);
            return artifact.getFile();
        }
        catch (AbstractArtifactResolutionException e) {
            throw new DeploymentException("Couldn't download artifact: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DeploymentException("Couldn't download artifact: " + e.getMessage());
        }
    }
}

