/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client;

import groovy.util.ScriptException;
import java.io.File;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractDeployer {
    protected final Deployment deploymentConfiguration;
    protected final DeployerLog log;

    public AbstractDeployer(Deployment deploymentConfiguration, DeployerLog log) throws DeploymentException {
        this.deploymentConfiguration = deploymentConfiguration;
        this.log = log;
        this.initialize();
    }

    public abstract void deploy() throws DeploymentException;

    public abstract void undeploy(MavenProject var1) throws DeploymentException;

    protected void info(String message) {
        this.log.info(message);
    }

    protected void error(String message) {
        this.log.error(message);
    }

    public String getApplicationName() {
        return this.deploymentConfiguration.getApplicationName();
    }

    public File getApplicationFile() {
        return this.deploymentConfiguration.getArtifact();
    }

    protected abstract void initialize() throws DeploymentException;

    public abstract void resolveDependencies(MavenProject var1, ArtifactResolver var2, ArchiverManager var3, ArtifactFactory var4, ArtifactRepository var5) throws DeploymentException, ScriptException;
}

