/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.arm;

import groovy.util.ScriptException;
import javax.ws.rs.NotFoundException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.arm.ArmClient;
import org.mule.tools.client.exception.ClientException;
import org.mule.tools.client.model.TargetType;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.utils.DeployerLog;

public class ArmDeployer
extends AbstractDeployer {
    private ArmDeployment armDeployment;
    private TargetType targetType;
    private String target;
    private ArmClient armClient;

    public ArmDeployer(ArmDeployment armDeployment, DeployerLog log) throws DeploymentException {
        super(armDeployment, log);
    }

    @Override
    public void deploy() throws DeploymentException {
        try {
            this.armClient.init();
            Integer applicationId = this.armClient.findApplication(this.getApplicationName(), this.targetType, this.target);
            if (applicationId == null) {
                this.info("Deploying application " + this.getApplicationName());
                this.armClient.deployApplication(this.getApplicationFile(), this.getApplicationName(), this.targetType, this.target);
            } else {
                String alreadyExistsMessage = "Found application %s on %s %s. Redeploying application...";
                this.info(String.format(alreadyExistsMessage, this.getApplicationName(), this.targetType.toString(), this.target));
                this.armClient.redeployApplication(applicationId, this.getApplicationFile(), this.getApplicationName(), this.targetType, this.target);
            }
        }
        catch (ClientException e) {
            this.error("Failed: " + e.getMessage());
            throw new DeploymentException("Failed to deploy application " + this.getApplicationName(), e);
        }
    }

    @Override
    public void undeploy(MavenProject mavenProject) throws DeploymentException {
        ArmClient armClient = new ArmClient(this.armDeployment, this.log);
        armClient.init();
        this.log.info("Undeploying application " + this.armDeployment.getApplicationName());
        try {
            armClient.undeployApplication(this.armDeployment.getApplicationName(), this.armDeployment.getTargetType(), this.armDeployment.getTarget());
        }
        catch (NotFoundException e) {
            if (this.armDeployment.isFailIfNotExists().get().booleanValue()) {
                throw e;
            }
            this.log.warn("Application not found: " + this.armDeployment.getApplicationName());
        }
    }

    @Override
    protected void initialize() {
        this.armDeployment = (ArmDeployment)this.deploymentConfiguration;
        this.targetType = this.armDeployment.getTargetType();
        this.target = this.armDeployment.getTarget();
        this.armClient = new ArmClient(this.armDeployment, this.log);
    }

    @Override
    public void resolveDependencies(MavenProject mavenProject, ArtifactResolver artifactResolver, ArchiverManager archiverManager, ArtifactFactory artifactFactory, ArtifactRepository localRepository) throws DeploymentException, ScriptException {
    }
}

