/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.model.anypoint;

import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.utils.DeployerLog;

public class DeploymentConfigurator {
    private final DeployerLog log;
    private AnypointDeployment anypointConfiguration;

    public DeploymentConfigurator(AnypointDeployment anypointConfiguration, DeployerLog log) {
        this.anypointConfiguration = anypointConfiguration;
        this.log = log;
    }

    public void initializeApplication(ArtifactFactory factory, MavenProject project, ArtifactResolver resolver, ArtifactRepository localRepository) throws MojoFailureException {
        if (this.anypointConfiguration.getArtifact() == null) {
            Artifact artifact = this.resolveMavenProjectArtifact(factory, project, resolver, localRepository);
            this.anypointConfiguration.setArtifact(artifact.getFile());
            this.log.info("No application configured. Using project artifact: " + this.anypointConfiguration.getArtifact());
            if (this.anypointConfiguration.getApplicationName() == null) {
                this.anypointConfiguration.setApplicationName(artifact.getArtifactId());
            }
        } else if (StringUtils.isBlank((CharSequence)this.anypointConfiguration.getApplicationName())) {
            this.anypointConfiguration.setApplicationName(this.anypointConfiguration.getArtifact().getName());
        }
    }

    protected Artifact resolveMavenProjectArtifact(ArtifactFactory factory, MavenProject project, ArtifactResolver resolver, ArtifactRepository localRepository) throws MojoFailureException {
        Artifact artifact = factory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "jar", project.getPackaging());
        try {
            resolver.resolve(artifact, new ArrayList(), localRepository);
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException e) {
            throw new MojoFailureException("Couldn't resolve artifact [" + artifact + "]");
        }
        return artifact;
    }

    public void initializeEnvironment(Settings settings, SettingsDecrypter decrypter) throws MojoExecutionException {
        String ibmJdkSupport;
        if (this.anypointConfiguration.getServer() != null) {
            Server serverObject = settings.getServer(this.anypointConfiguration.getServer());
            if (serverObject == null) {
                this.log.error("Server [" + this.anypointConfiguration.getServer() + "] not found in settings file.");
                throw new MojoExecutionException("Server [" + this.anypointConfiguration.getServer() + "] not found in settings file.");
            }
            serverObject = decrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(serverObject)).getServer();
            if (StringUtils.isNotEmpty((CharSequence)this.anypointConfiguration.getUsername()) || StringUtils.isNotEmpty((CharSequence)this.anypointConfiguration.getPassword())) {
                this.log.warn("Both server and credentials are configured. Using plugin configuration credentials.");
            } else {
                this.anypointConfiguration.setUsername(serverObject.getUsername());
                this.anypointConfiguration.setPassword(serverObject.getPassword());
            }
        }
        if ("true".equals(ibmJdkSupport = System.getProperty("ibm.jdk.support"))) {
            this.log.debug("Attempting to provide support for IBM JDK...");
            try {
                Field methods = HttpURLConnection.class.getDeclaredField("methods");
                methods.setAccessible(true);
                Field modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
                modifiers.setInt(methods, methods.getModifiers() & 0xFFFFFFEF);
                String[] actualMethods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "PATCH", "DELETE", "TRACE"};
                methods.set(null, actualMethods);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.log.error("Fail to provide support for IBM JDK", e);
            }
        }
    }
}

