/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.deployment;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.project.MavenProject;
import org.mule.tools.client.standalone.configuration.ClusterConfigurator;
import org.mule.tools.client.standalone.controller.MuleProcessController;
import org.mule.tools.client.standalone.controller.probing.PollingProber;
import org.mule.tools.client.standalone.controller.probing.deployment.DeploymentProbe;
import org.mule.tools.client.standalone.controller.probing.deployment.DeploymentProbeFactory;
import org.mule.tools.client.standalone.deployment.StandaloneUndeployer;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.client.standalone.exception.MuleControllerException;
import org.mule.tools.model.standalone.ClusterDeployment;
import org.mule.tools.utils.DeployerLog;

public class ClusterDeployer {
    private static final double MAX_CLUSTER_SIZE = 8.0;
    private static final long DEFAULT_POLLING_DELAY = 1000L;
    private static final Long DEFAULT_CLUSTER_DEPLOYMENT_TIMEOUT = 60000L;
    private final DeployerLog log;
    private File[] paths;
    private List<MuleProcessController> mules;
    private ClusterConfigurator configurator = new ClusterConfigurator();
    private final ClusterDeployment clusterDeployment;

    public ClusterDeployer(ClusterDeployment clusterDeployment, DeployerLog log) throws DeploymentException {
        this.log = log;
        this.clusterDeployment = clusterDeployment;
    }

    public String toString() {
        return String.format("StandaloneDeployer with [Controllers=%s, log=%s, application=%s, timeout=%d, pollingDelay=%d ]", this.mules, this.log, this.clusterDeployment.getArtifact(), this.clusterDeployment.getDeploymentTimeout().orElse(DEFAULT_CLUSTER_DEPLOYMENT_TIMEOUT), 1000L);
    }

    private void waitForDeployments() throws DeploymentException {
        for (MuleProcessController m : this.mules) {
            if (!this.clusterDeployment.getArtifact().exists()) {
                throw new DeploymentException("Application does not exists: " + this.clusterDeployment.getArtifact());
            }
            DeploymentProbe probe = DeploymentProbeFactory.createProbe(this.clusterDeployment.getPackaging());
            this.log.debug("Checking for application [" + this.clusterDeployment.getArtifact() + "] to be deployed.");
            String app = this.getApplicationName(this.clusterDeployment.getArtifact());
            try {
                new PollingProber(this.clusterDeployment.getDeploymentTimeout().orElse(DEFAULT_CLUSTER_DEPLOYMENT_TIMEOUT), 1000L).check(probe.isDeployed(m, app));
            }
            catch (AssertionError e) {
                this.log.error("Couldn't deploy application [" + this.clusterDeployment.getArtifact() + "] after [" + this.clusterDeployment.getDeploymentTimeout() + "] miliseconds. Check Mule Runtime log");
                throw new DeploymentException("Application deployment timeout.");
            }
        }
    }

    private String getApplicationName(File application) {
        String name = application.getName();
        int extensionBeginning = name.lastIndexOf(46);
        return extensionBeginning == -1 ? name : name.substring(0, extensionBeginning);
    }

    private void deployApplications() throws DeploymentException {
        for (MuleProcessController m : this.mules) {
            if (!this.clusterDeployment.getArtifact().exists()) {
                throw new DeploymentException("Application does not exists: " + this.clusterDeployment.getArtifact().getAbsolutePath());
            }
            this.log.info("Deploying application [" + this.clusterDeployment.getArtifact() + "]");
            try {
                m.deploy(this.clusterDeployment.getArtifact().getAbsolutePath());
            }
            catch (MuleControllerException e) {
                this.log.error("Couldn't deploy application: " + this.clusterDeployment.getArtifact() + ". Check Mule Runtime logs");
            }
        }
    }

    private void startMulesIfStopped() {
        for (MuleProcessController m : this.mules) {
            this.log.debug("Checking if Mule Runtime is running.");
            if (m.isRunning()) continue;
            try {
                this.log.info("Starting Mule Runtime");
                if (this.clusterDeployment.getArguments() == null) {
                    m.start(new String[0]);
                    continue;
                }
                m.start(this.clusterDeployment.getArguments());
            }
            catch (MuleControllerException e) {
                this.log.error("Couldn't start Mule Runtime. Check Mule Runtime logs");
            }
        }
    }

    public void deploy() throws DeploymentException {
        try {
            this.configurator.configureCluster(this.paths, this.mules);
            this.startMulesIfStopped();
            this.deployApplications();
            this.waitForDeployments();
        }
        catch (MuleControllerException e) {
            throw new DeploymentException("Error deploying application: [" + this.clusterDeployment.getArtifact() + "]");
        }
        catch (RuntimeException e) {
            throw new DeploymentException("Unexpected error deploying application: [" + this.clusterDeployment.getArtifact() + "]", e);
        }
    }

    public void undeploy(MavenProject mavenProject) throws DeploymentException {
        File[] muleHomes = new File[this.clusterDeployment.getSize().intValue()];
        for (int i = 0; i < this.clusterDeployment.getSize(); ++i) {
            File parentDir = new File(mavenProject.getBuild().getDirectory(), "mule" + i);
            muleHomes[i] = new File(parentDir, "mule-enterprise-standalone-" + this.clusterDeployment.getMuleVersion());
            if (muleHomes[i].exists()) continue;
            throw new DeploymentException(muleHomes[i].getAbsolutePath() + "directory does not exist.");
        }
        new StandaloneUndeployer(this.log, this.clusterDeployment.getApplicationName(), muleHomes).execute();
    }

    public void initialize() throws DeploymentException {
        this.validateSize();
        this.renameApplicationToApplicationName();
    }

    private void validateSize() throws DeploymentException {
        if ((double)this.clusterDeployment.getSize().intValue() > 8.0) {
            throw new DeploymentException("Cannot create cluster with more than 8 nodes");
        }
    }

    private void renameApplicationToApplicationName() throws DeploymentException {
        if (!FilenameUtils.getBaseName((String)this.clusterDeployment.getArtifact().getName()).equals(this.clusterDeployment.getApplicationName())) {
            try {
                File destApplication = new File(this.clusterDeployment.getArtifact().getParentFile(), this.clusterDeployment.getApplicationName() + ".jar");
                FileUtils.copyFile((File)this.clusterDeployment.getArtifact(), (File)destApplication);
                this.clusterDeployment.setArtifact(destApplication);
            }
            catch (IOException e) {
                throw new DeploymentException("Couldn't rename [" + this.clusterDeployment.getArtifact() + "] to [" + this.clusterDeployment.getApplicationName() + "]");
            }
        }
    }
}

