/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.arm;

import org.mule.tools.client.arm.ApplicationMetadata;
import org.mule.tools.client.arm.ArmClient;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.deployment.artifact.ArtifactDeployer;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.arm.ArmDeploymentVerification;

public class ArmArtifactDeployer
implements ArtifactDeployer {
    private static final Long DEFAULT_ARM_DEPLOYMENT_TIMEOUT = 1200000L;
    private final ArmDeployment deployment;
    private final DeployerLog log;
    private ArmClient client;
    private Integer applicationId;
    private boolean isClientInitialized = false;

    public ArmArtifactDeployer(Deployment deployment, DeployerLog log) {
        this(deployment, new ArmClient(deployment, log), log);
    }

    protected ArmArtifactDeployer(Deployment deployment, ArmClient client, DeployerLog log) {
        this.deployment = (ArmDeployment)deployment;
        if (!this.deployment.getDeploymentTimeout().isPresent()) {
            this.deployment.setDeploymentTimeout(DEFAULT_ARM_DEPLOYMENT_TIMEOUT);
        }
        this.client = client;
        this.log = log;
    }

    public ApplicationMetadata getApplicationMetadata() {
        return new ApplicationMetadata(this.deployment.getArtifact(), this.deployment.getApplicationName(), this.deployment.getTargetType(), this.deployment.getTarget());
    }

    public boolean isFailIfNotExists() {
        return this.deployment.isFailIfNotExists().orElse(true);
    }

    @Override
    public void deployDomain() throws DeploymentException {
        throw new DeploymentException("Deployment of domains to ARM is not supported");
    }

    @Override
    public void undeployDomain() throws DeploymentException {
        throw new DeploymentException("Undeployment of domains to ARM is not supported");
    }

    @Override
    public void deployApplication() throws DeploymentException {
        this.getClient().deployApplication(this.getApplicationMetadata());
        this.checkApplicationHasStarted();
    }

    protected void checkApplicationHasStarted() throws DeploymentException {
        this.log.info("Checking application: " + this.deployment.getApplicationName() + " has started");
        DeploymentVerification verification = this.getDeploymentVerification();
        verification.assertDeployment(this.deployment);
    }

    @Override
    public void undeployApplication() throws DeploymentException {
        this.getClient().undeployApplication(this.getApplicationMetadata());
    }

    public void redeployApplication() {
        this.log.info("Found " + this.getApplicationMetadata().toString() + ". Redeploying application...");
        this.getClient().redeployApplication(this.getApplicationId(), this.getApplicationMetadata());
    }

    public Integer getApplicationId() {
        if (this.applicationId == null) {
            this.applicationId = this.getClient().findApplicationId(this.getApplicationMetadata());
        }
        return this.applicationId;
    }

    protected String getApplicationName() {
        return this.deployment.getApplicationName();
    }

    protected ArmClient getClient() {
        if (!this.isClientInitialized) {
            this.client.init();
            this.isClientInitialized = true;
        }
        return this.client;
    }

    public DeploymentVerification getDeploymentVerification() {
        return new ArmDeploymentVerification(this.getClient(), this.getApplicationId());
    }
}

