/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.cloudhub;

import java.util.Map;
import java.util.Optional;
import org.mule.tools.client.cloudhub.Application;
import org.mule.tools.model.anypoint.CloudHubDeployment;

public class ApplicationMetadata {
    private String name;
    private String region;
    private Optional<String> muleVersion;
    private Integer workers;
    private String workerType;
    private Map<String, String> properties;

    public ApplicationMetadata(CloudHubDeployment deployment) {
        this.setName(deployment.getApplicationName()).setRegion(deployment.getRegion()).setMuleVersion(deployment.getMuleVersion()).setWorkers(deployment.getWorkers().get()).setWorkerType(deployment.getWorkerType()).setProperties(deployment.getProperties());
    }

    public ApplicationMetadata setName(String name) {
        this.name = name;
        return this;
    }

    public ApplicationMetadata setRegion(String region) {
        this.region = region;
        return this;
    }

    public ApplicationMetadata setMuleVersion(Optional<String> muleVersion) {
        this.muleVersion = muleVersion;
        return this;
    }

    public ApplicationMetadata setWorkers(Integer workers) {
        this.workers = workers;
        return this;
    }

    public ApplicationMetadata setWorkerType(String workerType) {
        this.workerType = workerType;
        return this;
    }

    public ApplicationMetadata setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        return this.region;
    }

    public Optional<String> getMuleVersion() {
        return this.muleVersion;
    }

    public Integer getWorkers() {
        return this.workers;
    }

    public String getWorkerType() {
        return this.workerType;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void updateValues(Application currentApplication) {
        this.region = this.region == null ? currentApplication.region : this.region;
        this.muleVersion = !this.muleVersion.isPresent() ? Optional.ofNullable(currentApplication.muleVersion) : this.muleVersion;
        this.workers = this.workers == null ? currentApplication.workers : this.workers;
        this.workerType = this.workerType == null ? currentApplication.workerType : this.workerType;
    }
}

