/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.validation;

import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.model.standalone.StandaloneDeployment;
import org.mule.tools.validation.AbstractDeploymentValidator;
import org.mule.tools.validation.agent.AgentDeploymentValidator;
import org.mule.tools.validation.arm.ArmDeploymentValidator;
import org.mule.tools.validation.cloudhub.CloudHubDeploymentValidator;
import org.mule.tools.validation.standalone.StandaloneDeploymentValidator;

public class DeploymentValidatorFactory {
    public static AbstractDeploymentValidator createDeploymentValidator(Deployment deployment) throws DeploymentException {
        if (deployment instanceof AgentDeployment) {
            return new AgentDeploymentValidator(deployment);
        }
        if (deployment instanceof StandaloneDeployment) {
            return new StandaloneDeploymentValidator(deployment);
        }
        if (deployment instanceof CloudHubDeployment) {
            return new CloudHubDeploymentValidator(deployment);
        }
        if (deployment instanceof ArmDeployment) {
            return new ArmDeploymentValidator(deployment);
        }
        throw new DeploymentException("Cannot configuration is not supported");
    }
}

