/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.agent;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.mule.tools.client.agent.ClientLoggingFilter;
import org.mule.tools.client.exception.ClientException;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractClient {
    private static final String USER_AGENT_MULE_DEPLOYER = "mule-deployer%s";
    protected DeployerLog log;

    public AbstractClient() {
    }

    public AbstractClient(DeployerLog log) {
        this.log = log;
    }

    protected WebTarget getTarget(String uri, String path) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        this.configureSecurityContext(builder);
        Client client = (Client)builder.build().register(MultiPartFeature.class);
        if (this.log != null && this.log.isDebugEnabled() && !this.isLoginRequest(path)) {
            client.register((Object)new ClientLoggingFilter(this.log));
        }
        return client.target(uri).path(path);
    }

    private boolean isLoginRequest(String path) {
        return "/accounts/login".equals(path);
    }

    protected void validateStatusSuccess(Response response) {
        if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new ClientException(response);
        }
    }

    protected void configureSecurityContext(ClientBuilder builder) {
    }

    protected Response post(String uri, String path, Entity entity) {
        return this.builder(uri, path).post(entity);
    }

    protected Response post(String uri, String path, Object entity) {
        return this.post(uri, path, Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response put(String uri, String path, Entity entity) {
        return this.builder(uri, path).put(entity);
    }

    protected Response put(String uri, String path, Object entity) {
        return this.put(uri, path, Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response delete(String uri, String path) {
        return this.builder(uri, path).delete();
    }

    protected Response get(String uri, String path) {
        return this.builder(uri, path).get();
    }

    protected <T> T get(String uri, String path, Class<T> clazz) {
        return (T)this.get(uri, path).readEntity(clazz);
    }

    protected Response patch(String uri, String path, Entity entity) {
        Invocation.Builder builder = this.builder(uri, path);
        builder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        return builder.method("PATCH", entity);
    }

    private Invocation.Builder builder(String uri, String path) {
        WebTarget target = this.getTarget(uri, path);
        Invocation.Builder builder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.getUserAgentMuleDeployer());
        this.configureRequest(builder);
        return builder;
    }

    protected String getUserAgentMuleDeployer() {
        Package classPackage = AbstractClient.class.getPackage();
        String implementationVersion = classPackage != null ? classPackage.getImplementationVersion() : "";
        String version = StringUtils.isNotBlank((CharSequence)implementationVersion) ? "-[" + implementationVersion + "]" : "";
        return String.format(USER_AGENT_MULE_DEPLOYER, version);
    }

    protected void configureRequest(Invocation.Builder builder) {
    }
}

