/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.cloudhub;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.cloudhub.Application;
import org.mule.tools.client.cloudhub.ApplicationMetadata;
import org.mule.tools.client.cloudhub.CloudHubClient;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.deployment.artifact.ArtifactDeployer;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.verification.cloudhub.CloudHubDeploymentVerification;

public class CloudHubArtifactDeployer
implements ArtifactDeployer {
    private static final Long DEFAULT_CLOUDHUB_DEPLOYMENT_TIMEOUT = 600000L;
    private final CloudHubDeployment deployment;
    private final DeployerLog log;
    private CloudHubClient client;
    private ApplicationMetadata application;
    private boolean isClientInitialized = false;

    public CloudHubArtifactDeployer(Deployment deployment, DeployerLog log) {
        this(deployment, CloudHubArtifactDeployer.getCloudHubClient(deployment, log), log);
    }

    public CloudHubArtifactDeployer(Deployment deployment, CloudHubClient cloudHubClient, DeployerLog log) {
        this.deployment = (CloudHubDeployment)deployment;
        if (!this.deployment.getDeploymentTimeout().isPresent()) {
            this.deployment.setDeploymentTimeout(DEFAULT_CLOUDHUB_DEPLOYMENT_TIMEOUT);
        }
        this.client = cloudHubClient;
        this.log = log;
    }

    @Override
    public void deployDomain() throws DeploymentException {
        throw new DeploymentException("Deployment of domains to CloudHub is not supported");
    }

    @Override
    public void undeployDomain() throws DeploymentException {
        throw new DeploymentException("Uneployment of domains from CloudHub is not supported");
    }

    @Override
    public void deployApplication() throws DeploymentException {
        this.persistApplication();
        this.uploadContents();
        this.startApplication();
        this.checkApplicationHasStarted();
    }

    @Override
    public void undeployApplication() throws DeploymentException {
        this.log.info("Stopping application " + this.deployment.getApplicationName());
        this.getClient().stopApplication(this.deployment.getApplicationName());
    }

    protected void persistApplication() throws DeploymentException {
        ApplicationMetadata applicationMetadata = this.getMetadata();
        boolean domainAvailable = this.getClient().isNameAvailable(this.deployment.getApplicationName());
        if (domainAvailable) {
            this.createApplication(applicationMetadata);
        } else {
            this.updateApplication(applicationMetadata);
        }
    }

    protected void uploadContents() {
        this.log.info("Uploading application contents " + this.deployment.getApplicationName());
        this.getClient().uploadFile(this.deployment.getApplicationName(), this.deployment.getArtifact());
    }

    protected void createApplication(ApplicationMetadata applicationMetadata) {
        this.log.info("Creating application: " + this.deployment.getApplicationName());
        this.getClient().createApplication(applicationMetadata);
    }

    protected void updateApplication(ApplicationMetadata applicationMetadata) throws DeploymentException {
        Application currentApplication = this.findApplicationFromCurrentUser(this.deployment.getApplicationName());
        if (currentApplication == null) {
            this.log.error("Application name: " + this.deployment.getApplicationName() + " is not available. Aborting.");
            throw new DeploymentException("Domain " + this.deployment.getApplicationName() + " is not available. Aborting.");
        }
        this.log.info("Application: " + this.deployment.getApplicationName() + " already exists, redeploying");
        applicationMetadata.updateValues(currentApplication);
        this.getClient().updateApplication(applicationMetadata);
    }

    protected void startApplication() {
        this.log.info("Starting application: " + this.deployment.getApplicationName());
        this.getClient().startApplication(this.deployment.getApplicationName());
    }

    protected void checkApplicationHasStarted() throws DeploymentException {
        this.log.info("Checking if application: " + this.deployment.getApplicationName() + " has started");
        CloudHubDeploymentVerification verification = this.getDeploymentVerification();
        verification.assertDeployment(this.deployment);
    }

    protected Application findApplicationFromCurrentUser(String appName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appName), (Object)"Application name should not be blank nor null");
        for (Application app : this.getClient().getApplications()) {
            if (!appName.equalsIgnoreCase(app.domain)) continue;
            return app;
        }
        return null;
    }

    protected String getApplicationName() {
        return this.deployment.getApplicationName();
    }

    public CloudHubClient getClient() {
        if (!this.isClientInitialized) {
            this.client.init();
            this.isClientInitialized = true;
        }
        return this.client;
    }

    private static CloudHubClient getCloudHubClient(Deployment deployment, DeployerLog log) {
        return new CloudHubClient((CloudHubDeployment)deployment, log);
    }

    public ApplicationMetadata getMetadata() {
        if (this.application == null) {
            this.application = new ApplicationMetadata(this.deployment);
        }
        return this.application;
    }

    public CloudHubDeploymentVerification getDeploymentVerification() {
        return new CloudHubDeploymentVerification(this.getClient());
    }
}

