/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.verification;

import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.mule.tools.client.OperationRetrier;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.DeploymentVerificationStrategy;

public class DefaultDeploymentVerification
implements DeploymentVerification {
    private final OperationRetrier retrier;
    private final Consumer<Deployment> onTimeout;
    private final Predicate<Deployment> isDeployed;

    public DefaultDeploymentVerification(DeploymentVerificationStrategy handler) {
        this(new OperationRetrier(), handler);
    }

    protected DefaultDeploymentVerification(OperationRetrier retrier, DeploymentVerificationStrategy verificationStrategy) {
        this.retrier = retrier;
        this.onTimeout = verificationStrategy.onTimeout();
        this.isDeployed = verificationStrategy.isDeployed();
    }

    @Override
    public void assertDeployment(Deployment deployment) throws DeploymentException {
        deployment.getDeploymentTimeout().ifPresent(this.retrier::setTimeout);
        try {
            this.retrier.retry(() -> !this.isDeployed.test(deployment));
        }
        catch (InterruptedException | TimeoutException e) {
            this.onTimeout.accept(deployment);
            throw new DeploymentException("Deployment has timeouted", e);
        }
        catch (IllegalStateException e) {
            this.onTimeout.accept(deployment);
            throw new DeploymentException("Deployment has failed", e);
        }
    }
}

