/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.verification.cloudhub;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.cloudhub.Application;
import org.mule.tools.client.cloudhub.CloudHubClient;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.verification.DefaultDeploymentVerification;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.DeploymentVerificationStrategy;

public class CloudHubDeploymentVerification
implements DeploymentVerification {
    private final CloudHubClient client;
    private DefaultDeploymentVerification verification;
    private static final String FAILED_STATUS = "FAIL";
    public static final String STARTED_STATUS = "STARTED";

    public CloudHubDeploymentVerification(CloudHubClient client) {
        this.client = client;
        this.verification = new DefaultDeploymentVerification(new CloudHubDeploymentVerificationStrategy());
    }

    @Override
    public void assertDeployment(Deployment deployment) throws DeploymentException {
        this.verification.assertDeployment(deployment);
    }

    private class CloudHubDeploymentVerificationStrategy
    implements DeploymentVerificationStrategy {
        private CloudHubDeploymentVerificationStrategy() {
        }

        @Override
        public Predicate<Deployment> isDeployed() {
            return deployment -> {
                Application application = CloudHubDeploymentVerification.this.client.getApplication(deployment.getApplicationName());
                if (application != null) {
                    if (StringUtils.containsIgnoreCase((CharSequence)application.status, (CharSequence)CloudHubDeploymentVerification.FAILED_STATUS)) {
                        throw new IllegalStateException("Deployment failed");
                    }
                    if (StringUtils.equals((CharSequence)CloudHubDeploymentVerification.STARTED_STATUS, (CharSequence)application.status)) {
                        return true;
                    }
                }
                return false;
            };
        }

        @Override
        public Consumer<Deployment> onTimeout() {
            return deployment -> CloudHubDeploymentVerification.this.client.stopApplication(deployment.getApplicationName());
        }
    }
}

