/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.arm.model.Environment;
import org.mule.tools.client.arm.model.Environments;
import org.mule.tools.client.arm.model.Organization;
import org.mule.tools.client.arm.model.User;
import org.mule.tools.client.arm.model.UserInfo;
import org.mule.tools.client.authentication.AuthenticationServiceClient;
import org.mule.tools.client.authentication.model.AnypointCredential;
import org.mule.tools.client.authentication.model.AnypointToken;
import org.mule.tools.client.authentication.model.Credentials;
import org.mule.tools.client.core.AbstractClient;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractMuleClient
extends AbstractClient {
    public static final String DEFAULT_BASE_URL = "https://anypoint.mulesoft.com";
    private static final String ENV_ID_HEADER = "X-ANYPNT-ENV-ID";
    private static final String ORG_ID_HEADER = "X-ANYPNT-ORG-ID";
    private static final String ME = "/accounts/api/me";
    private static final String ENVIRONMENTS = "/accounts/api/organizations/%s/environments";
    public static final String ORGANIZATION = "organization";
    public static final String SUB_ORGANIZATION_IDS = "subOrganizationIds";
    public static final String NAME = "name";
    public static final String USER = "user";
    public static final String ID = "id";
    public static final String UNAUTHORIZED = "unauthorized";
    protected String baseUri;
    private String bearerToken;
    private AnypointCredential credentials;
    protected AuthenticationServiceClient authenticationServiceClient;
    private String envId;
    private String environmentName;
    private String orgId;
    private String businessGroupName;

    public AbstractMuleClient(AnypointDeployment anypointDeployment, DeployerLog log) {
        super(log);
        this.baseUri = anypointDeployment.getUri();
        this.credentials = !StringUtils.isEmpty((CharSequence)anypointDeployment.getAuthToken()) ? new AnypointToken(anypointDeployment.getAuthToken()) : new Credentials(anypointDeployment.getUsername(), anypointDeployment.getPassword());
        this.authenticationServiceClient = new AuthenticationServiceClient(this.baseUri);
        this.environmentName = anypointDeployment.getEnvironment();
        this.businessGroupName = anypointDeployment.getBusinessGroup();
    }

    public AbstractMuleClient(DeployerLog log) {
        super(log);
    }

    @Override
    public void init() {
        this.bearerToken = this.getBearerToken(this.credentials);
        this.orgId = this.getOrgId();
        this.envId = this.findEnvironmentByName((String)this.environmentName).id;
    }

    public UserInfo getMe() {
        String userInfoJsonString = this.get(this.baseUri, ME, String.class);
        if (userInfoJsonString.equalsIgnoreCase(UNAUTHORIZED)) {
            StringBuilder message = new StringBuilder();
            message.append("Unauthorized Access. Please verify that authToken is valid.");
            throw new RuntimeException(message.toString());
        }
        JsonObject userInfoJson = (JsonObject)new JsonParser().parse(userInfoJsonString);
        Organization organization = this.buildOrganization(userInfoJson);
        User user = new User();
        user.organization = organization;
        UserInfo userInfo = new UserInfo();
        userInfo.user = user;
        return userInfo;
    }

    protected Organization buildOrganization(JsonObject userInfoJson) {
        HashMap<String, Organization> organizationsIds = new HashMap<String, Organization>();
        HashMap<String, List<String>> organizationChildren = new HashMap<String, List<String>>();
        this.buildOrganizationsMap(userInfoJson, organizationsIds, organizationChildren);
        String root = this.getRootOrganization(userInfoJson);
        return this.recurse(root, organizationsIds, organizationChildren);
    }

    private Organization recurse(String root, Map<String, Organization> organizationsIds, Map<String, List<String>> organizationChildren) {
        Organization organization = organizationsIds.get(root);
        List<String> children = organizationChildren.get(root);
        if (children != null) {
            for (String child : children) {
                Organization org = this.recurse(child, organizationsIds, organizationChildren);
                if (org == null) continue;
                organization.subOrganizations.add(org);
            }
        }
        return organization;
    }

    private String getRootOrganization(JsonObject userInfoJson) {
        JsonObject organizationJson;
        JsonObject userJson;
        if (userInfoJson != null && userInfoJson.has(USER) && (userJson = (JsonObject)userInfoJson.get(USER)) != null && userJson.has(ORGANIZATION) && (organizationJson = userJson.getAsJsonObject(ORGANIZATION)).has(NAME)) {
            return organizationJson.get(ID).getAsString();
        }
        throw new IllegalStateException("Cannot find root organization");
    }

    private void buildOrganizationsMap(JsonObject userInfoJson, Map<String, Organization> organizationsIds, Map<String, List<String>> organizationChildren) {
        if (userInfoJson != null && userInfoJson.has(USER)) {
            JsonObject userJson = (JsonObject)userInfoJson.get(USER);
            JsonArray organizations = this.getAllOrganizations(userJson);
            for (JsonElement orgJson : organizations) {
                if (!orgJson.isJsonObject()) continue;
                Organization org = new Organization();
                org.id = ((JsonObject)orgJson).get(ID).getAsString();
                org.name = ((JsonObject)orgJson).get(NAME).getAsString();
                org.subOrganizations = new ArrayList<Organization>();
                List<String> childrenIds = this.getChildren(orgJson);
                organizationsIds.put(org.id, org);
                organizationChildren.put(org.id, childrenIds);
            }
        }
    }

    private List<String> getChildren(JsonElement orgJson) {
        JsonArray children = ((JsonObject)orgJson).get(SUB_ORGANIZATION_IDS).getAsJsonArray();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < children.size(); ++i) {
            ids.add(children.get(i).getAsString());
        }
        return ids;
    }

    private JsonArray getAllOrganizations(JsonObject userJson) {
        JsonArray organizations = new JsonArray();
        if (userJson.has("memberOfOrganizations")) {
            organizations.addAll(userJson.get("memberOfOrganizations").getAsJsonArray());
        }
        if (userJson.has("contributorOfOrganizations")) {
            organizations.addAll(userJson.get("contributorOfOrganizations").getAsJsonArray());
        }
        return organizations;
    }

    public String getOrgId() {
        return this.getBusinessGroupIdByBusinessGroupPath();
    }

    public String getEnvId() {
        return this.envId;
    }

    public Environment findEnvironmentByName(String name) {
        Environments response = this.getEnvironments();
        if (response == null || response.data == null) {
            StringBuilder message = new StringBuilder();
            message.append("Please check whether you have the access rights to this business group.");
            if (StringUtils.isEmpty((CharSequence)this.businessGroupName)) {
                message.append(" Please set the businessGroup in the plugin configuration in case your user have access only within a business unit.");
            }
            throw new RuntimeException(message.toString());
        }
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find environmentName named [" + name + "]");
    }

    @Override
    protected void configureRequest(Invocation.Builder builder) {
        if (this.bearerToken != null) {
            builder.header("Authorization", (Object)("bearer " + this.bearerToken));
        }
        if (this.envId != null && this.orgId != null) {
            builder.header(ENV_ID_HEADER, (Object)this.envId);
            builder.header(ORG_ID_HEADER, (Object)this.orgId);
        }
    }

    protected String[] createBusinessGroupPath() {
        int i;
        if (StringUtils.isEmpty((CharSequence)this.businessGroupName)) {
            return new String[0];
        }
        ArrayList<String> groups = new ArrayList<String>();
        String group = "";
        for (i = 0; i < this.businessGroupName.length() - 1; ++i) {
            if (this.businessGroupName.charAt(i) == '\\') {
                if (this.businessGroupName.charAt(i + 1) == '\\') {
                    group = group + "\\";
                    ++i;
                    continue;
                }
                groups.add(group);
                group = "";
                continue;
            }
            group = group + this.businessGroupName.charAt(i);
        }
        if (i < this.businessGroupName.length()) {
            group = group + this.businessGroupName.charAt(this.businessGroupName.length() - 1);
        }
        groups.add(group);
        return groups.toArray(new String[0]);
    }

    public String getBusinessGroupIdByBusinessGroupPath() {
        String currentOrgId = null;
        Organization organizationHierarchy = this.getMe().user.organization;
        if (organizationHierarchy.subOrganizations.isEmpty()) {
            return organizationHierarchy.id;
        }
        List<Organization> subOrganizations = organizationHierarchy.subOrganizations;
        String[] groups = this.createBusinessGroupPath();
        if (groups.length == 0) {
            currentOrgId = organizationHierarchy.id;
        } else {
            block0: for (int group = 0; group < groups.length; ++group) {
                String groupName = groups[group];
                for (Organization o : subOrganizations) {
                    if (!o.name.equals(groupName)) continue;
                    currentOrgId = o.id;
                    subOrganizations = o.subOrganizations;
                    continue block0;
                }
            }
        }
        if (currentOrgId == null) {
            throw new ArrayIndexOutOfBoundsException("Cannot find business group.");
        }
        return currentOrgId;
    }

    private String getBearerToken(AnypointCredential credentials) {
        if (StringUtils.isBlank((CharSequence)this.bearerToken)) {
            switch (credentials.credentialType()) {
                case user: {
                    Credentials creds = (Credentials)credentials;
                    this.bearerToken = this.authenticationServiceClient.getBearerToken(creds);
                    break;
                }
                case token: {
                    this.bearerToken = ((AnypointToken)credentials).getToken();
                }
            }
        }
        return this.bearerToken;
    }

    public Environments getEnvironments() {
        return this.get(this.baseUri, String.format(ENVIRONMENTS, this.orgId), Environments.class);
    }

    public Set<String> getSuborganizationIds(JsonObject organizationJson) {
        HashSet<String> suborganizationIds = new HashSet<String>();
        JsonArray subOrganizationIds = organizationJson.get(SUB_ORGANIZATION_IDS).getAsJsonArray();
        if (subOrganizationIds != null) {
            for (JsonElement id : subOrganizationIds) {
                suborganizationIds.add(id.getAsString());
            }
        }
        return suborganizationIds;
    }
}

