/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.authentication;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.arm.model.AuthorizationResponse;
import org.mule.tools.client.arm.model.Environment;
import org.mule.tools.client.arm.model.Environments;
import org.mule.tools.client.arm.model.Organization;
import org.mule.tools.client.arm.model.UserInfo;
import org.mule.tools.client.authentication.model.Credentials;
import org.mule.tools.client.core.AbstractClient;

public class AuthenticationServiceClient
extends AbstractClient {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String LOGIN = "/accounts/login";
    public static final String BASE = "/accounts/api";
    public static final String ME = "/accounts/api/me";
    public static final String ORGANIZATIONS = "/accounts/api/organizations";
    public static final String ENVIRONMENTS = "/accounts/api/organizations/%s/environments";
    private String baseUri;
    private Boolean saveState;
    private String bearerToken;

    public AuthenticationServiceClient(String baseUri) {
        this(baseUri, false);
    }

    public AuthenticationServiceClient(String baseUri, Boolean saveState) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)baseUri), (Object)"The baseUri must not be null nor empty");
        this.baseUri = baseUri;
        this.saveState = saveState;
    }

    @Override
    protected void init() {
    }

    public String getBearerToken(Credentials credentials) {
        AuthorizationResponse authorizationResponse = this.login(credentials);
        if (this.saveState.booleanValue()) {
            this.bearerToken = authorizationResponse.access_token;
        }
        return authorizationResponse.access_token;
    }

    public UserInfo getMe() {
        UserInfo userInfo = this.get(this.baseUri, ME, UserInfo.class);
        return userInfo;
    }

    public List<Organization> getOrganizations() {
        Response response = this.get(this.baseUri, ORGANIZATIONS);
        Type listType = new TypeToken<ArrayList<Organization>>(){}.getType();
        List organizationList = (List)new Gson().fromJson((String)response.readEntity(String.class), listType);
        return organizationList;
    }

    public List<Environment> getEnvironments(String organizationId) {
        Environments environments = this.get(this.baseUri, String.format(ENVIRONMENTS, organizationId), Environments.class);
        return Arrays.asList(environments.data);
    }

    @Override
    protected void configureRequest(Invocation.Builder builder) {
        if (this.bearerToken != null) {
            builder.header(AUTHORIZATION_HEADER, (Object)("bearer " + this.bearerToken));
        }
    }

    private AuthorizationResponse login(Credentials credentials) {
        Entity credentialsEntity = Entity.json((Object)new Gson().toJson((Object)credentials));
        Response response = this.post(this.baseUri, LOGIN, credentialsEntity);
        this.checkResponseStatus(response);
        return (AuthorizationResponse)response.readEntity(AuthorizationResponse.class);
    }
}

