/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.cloudhub;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.mule.tools.client.AbstractMuleClient;
import org.mule.tools.client.cloudhub.model.Application;
import org.mule.tools.client.cloudhub.model.Deployment;
import org.mule.tools.client.cloudhub.model.DeploymentLogRequest;
import org.mule.tools.client.cloudhub.model.DomainAvailability;
import org.mule.tools.client.cloudhub.model.LogRecord;
import org.mule.tools.client.cloudhub.model.PaginatedResponse;
import org.mule.tools.client.cloudhub.model.SupportedVersion;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.utils.DeployerLog;

public class CloudHubClient
extends AbstractMuleClient {
    private static final String API_VERSION = "v2";
    public static final String BASE_API_PATH = "/cloudhub/api";
    public static final String SUPPORTED_VERSIONS_PATH = "/cloudhub/api/mule-versions";
    public static final String APPLICATION_STATUS = "/cloudhub/api/applications/%s/status";
    public static final String APPLICATIONS_DOMAINS_PATH = "/cloudhub/api/applications/domains/%s";
    public static final String BASE_API_VERSION_PATH = "/cloudhub/api/v2";
    public static final String APPLICATIONS_PATH = "/cloudhub/api/v2/applications";
    public static final String A_APPLICATION_PATH = "/cloudhub/api/v2/applications/%s";
    public static final String A_APPLICATION_LOGS = "/cloudhub/api/v2/applications/%s/logs";
    public static final String DEPLOYMENTS_PATH = "/cloudhub/api/v2/applications/%s/deployments";

    public CloudHubClient(CloudHubDeployment cloudhubDeployment, DeployerLog log) {
        super(cloudhubDeployment, log);
    }

    public List<Application> getApplications() {
        Response response = this.get(this.baseUri, APPLICATIONS_PATH);
        this.checkResponseStatus(response, Response.Status.OK);
        return (List)response.readEntity((GenericType)new GenericType<List<Application>>(){});
    }

    public Application getApplications(String domain) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)domain), (Object)"The domain must not be null nor empty.");
        Response response = this.get(this.baseUri, String.format(A_APPLICATION_PATH, domain));
        this.checkResponseStatus(response, Response.Status.OK, Response.Status.NOT_FOUND);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (Application)this.readJsonEntity(response, (Type)((Object)Application.class));
        }
        return null;
    }

    public Application createApplication(Application application, File file) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"The file must not be null.");
        Preconditions.checkArgument((application != null ? 1 : 0) != 0, (Object)"The application must not be null.");
        Entity<MultiPart> entity = this.getMultiPartEntity(application, file);
        Response response = this.post(this.baseUri, APPLICATIONS_PATH, entity);
        this.checkResponseStatus(response, Response.Status.OK);
        return (Application)response.readEntity(Application.class);
    }

    public Application updateApplication(Application application, File file) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"The file must not be null.");
        Preconditions.checkArgument((application != null ? 1 : 0) != 0, (Object)"The application must not be null.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)application.getDomain()), (Object)"The application domain must not be null nor empty.");
        Entity<MultiPart> entity = this.getMultiPartEntity(application, file);
        Response response = this.put(this.baseUri, String.format(A_APPLICATION_PATH, application.getDomain()), entity);
        this.checkResponseStatus(response, Response.Status.OK);
        return (Application)response.readEntity(Application.class);
    }

    public void deleteApplications(String domain) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)domain), (Object)"The domain must not be null nor empty.");
        Response response = this.delete(this.baseUri, String.format(A_APPLICATION_PATH, domain));
        this.checkResponseStatus(response, Response.Status.OK, Response.Status.NO_CONTENT);
    }

    public void startApplications(String domain) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)domain), (Object)"The domain must not be null nor empty.");
        Application application = new Application();
        application.setStatus("START");
        Response response = this.post(this.baseUri, String.format(APPLICATION_STATUS, domain), (Object)new Gson().toJson((Object)application));
        this.checkResponseStatus(response, Response.Status.OK, Response.Status.NOT_MODIFIED);
    }

    public void stopApplications(String domain) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)domain), (Object)"The domain must not be null nor empty.");
        Application application = new Application();
        application.setStatus("STOP");
        Response response = this.post(this.baseUri, String.format(APPLICATION_STATUS, domain), (Object)new Gson().toJson((Object)application));
        this.checkResponseStatus(response, Response.Status.OK, Response.Status.NOT_MODIFIED);
    }

    public boolean isDomainAvailable(String domain) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)domain), (Object)"The domain must not be null nor empty.");
        Response response = this.get(this.baseUri, String.format(APPLICATIONS_DOMAINS_PATH, domain));
        this.checkResponseStatus(response, Response.Status.OK);
        DomainAvailability availability = (DomainAvailability)response.readEntity(DomainAvailability.class);
        return availability.isAvailable();
    }

    public List<SupportedVersion> getSupportedMuleVersions() {
        Response response = this.get(this.baseUri, SUPPORTED_VERSIONS_PATH);
        this.checkResponseStatus(response, Response.Status.OK);
        Type type = new TypeToken<PaginatedResponse<SupportedVersion>>(){}.getType();
        PaginatedResponse paginatedResponse = (PaginatedResponse)this.readJsonEntity(response, type);
        return paginatedResponse.getData();
    }

    public List<Deployment> getDeployments(Application application) {
        Preconditions.checkArgument((application != null ? 1 : 0) != 0, (Object)"The application must not be null.");
        Response response = this.get(this.baseUri, String.format(DEPLOYMENTS_PATH, application.getDomain()));
        this.checkResponseStatus(response, Response.Status.OK);
        Type type = new TypeToken<PaginatedResponse<Deployment>>(){}.getType();
        PaginatedResponse paginatedResponse = (PaginatedResponse)this.readJsonEntity(response, type);
        return paginatedResponse.getData();
    }

    public List<LogRecord> getLogs(Application application, DeploymentLogRequest deploymentLogRequest) {
        Preconditions.checkArgument((deploymentLogRequest != null ? 1 : 0) != 0, (Object)"The log request must not be null.");
        Preconditions.checkArgument((application != null ? 1 : 0) != 0, (Object)"The application must not be null.");
        Response response = this.post(this.baseUri, String.format(A_APPLICATION_LOGS, application.getDomain()), (Object)deploymentLogRequest);
        this.checkResponseStatus(response, Response.Status.OK);
        return (List)response.readEntity((GenericType)new GenericType<List<LogRecord>>(){});
    }

    private Entity<MultiPart> getMultiPartEntity(Application application, File file) {
        FileDataBodyPart filePart = new FileDataBodyPart("file", file);
        FormDataBodyPart appInfoJsonPart = new FormDataBodyPart("appInfoJson", new Gson().toJson((Object)application));
        MultiPart multipart = new FormDataMultiPart().bodyPart((BodyPart)filePart).bodyPart((BodyPart)appInfoJsonPart);
        return Entity.entity((Object)multipart, (MediaType)multipart.getMediaType());
    }
}

