/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.model.anypoint;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.client.core.exception.DeploymentException;

public class RuntimeFabricDeploymentSettings {
    protected String runtimeVersion;
    @Parameter
    protected Integer replicationFactor;
    @Parameter
    protected String memoryReserved;
    @Parameter
    protected String memoryMax;
    @Parameter
    protected String cpuReserved;
    @Parameter
    protected String cpuMax;
    @Parameter
    protected String publicUrl;
    @Parameter
    protected boolean lastMileSecurity;
    @Parameter
    protected boolean clusteringEnabled;
    @Parameter
    protected String updateStrategy;

    public RuntimeFabricDeploymentSettings() {
    }

    public RuntimeFabricDeploymentSettings(RuntimeFabricDeploymentSettings settings) {
        this.runtimeVersion = settings.runtimeVersion;
        this.replicationFactor = settings.replicationFactor;
        this.memoryReserved = settings.memoryReserved;
        this.memoryMax = settings.memoryMax;
        this.cpuReserved = settings.cpuReserved;
        this.cpuMax = settings.cpuMax;
        this.publicUrl = settings.publicUrl;
        this.lastMileSecurity = settings.lastMileSecurity;
        this.clusteringEnabled = settings.clusteringEnabled;
        this.updateStrategy = settings.updateStrategy;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public String getMemoryReserved() {
        return this.memoryReserved;
    }

    public void setMemoryReserved(String memoryReserved) {
        this.memoryReserved = memoryReserved;
    }

    public String getMemoryMax() {
        return this.memoryMax;
    }

    public void setMemoryMax(String memoryMax) {
        this.memoryMax = memoryMax;
    }

    public String getCpuReserved() {
        return this.cpuReserved;
    }

    public void setCpuReserved(String cpuReserved) {
        this.cpuReserved = cpuReserved;
    }

    public String getCpuMax() {
        return this.cpuMax;
    }

    public void setCpuMax(String cpuMax) {
        this.cpuMax = cpuMax;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public boolean getLastMileSecurity() {
        return this.lastMileSecurity;
    }

    public void setLastMileSecurity(boolean lastMileSecurity) {
        this.lastMileSecurity = lastMileSecurity;
    }

    public boolean isClusteringEnabled() {
        return this.clusteringEnabled;
    }

    public void setClusteringEnabled(boolean clusteringEnabled) {
        this.clusteringEnabled = clusteringEnabled;
    }

    public String getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(String updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public void setEnvironmentSpecificValues() throws DeploymentException {
        if (this.getReplicationFactor() == null) {
            this.setReplicationFactor(1);
        }
        if (this.isClusteringEnabled() && this.getReplicationFactor().equals(1)) {
            throw new DeploymentException("Invalid deployment configuration, replicas must be bigger than 1 to enable Runtime Cluster Mode. Please either set enableRuntimeClusterMode to false or increase the number of replicas");
        }
        if (StringUtils.isEmpty((CharSequence)this.getMemoryReserved())) {
            this.setMemoryReserved("700Mi");
        }
        if (StringUtils.isEmpty((CharSequence)this.getMemoryMax())) {
            this.setMemoryMax(this.getMemoryReserved());
        }
        if (StringUtils.isEmpty((CharSequence)this.getCpuReserved())) {
            this.setCpuReserved("500m");
        }
        if (StringUtils.isEmpty((CharSequence)this.getCpuMax())) {
            this.setCpuMax(this.getCpuReserved());
        }
        if (StringUtils.isEmpty((CharSequence)this.getUpdateStrategy())) {
            this.setUpdateStrategy("rolling");
        }
    }
}

