/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.model.anypoint;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.anypoint.Http;
import org.mule.tools.model.anypoint.Jvm;
import org.mule.tools.model.anypoint.Resources;

public class RuntimeFabricDeploymentSettings {
    @Parameter
    protected String runtimeVersion;
    @Parameter
    protected Resources resources;
    @Parameter
    protected boolean lastMileSecurity;
    @Parameter
    protected boolean persistentObjectStore;
    @Parameter
    protected boolean clustered;
    @Parameter
    protected String updateStrategy;
    @Parameter
    protected boolean enforceDeployingReplicasAcrossNodes;
    @Parameter
    protected Http http;
    @Parameter
    protected Jvm jvm;
    @Parameter
    protected boolean forwardSslSession;
    @Parameter
    protected boolean disableAmLogForwarding;

    public RuntimeFabricDeploymentSettings() {
        this.http = new Http();
        this.resources = new Resources();
    }

    public RuntimeFabricDeploymentSettings(RuntimeFabricDeploymentSettings settings) {
        this.runtimeVersion = settings.runtimeVersion;
        this.resources = settings.resources;
        this.lastMileSecurity = settings.lastMileSecurity;
        this.persistentObjectStore = settings.persistentObjectStore;
        this.clustered = settings.clustered;
        this.updateStrategy = settings.updateStrategy;
        if (settings.jvm != null) {
            this.jvm = settings.jvm;
        }
        this.enforceDeployingReplicasAcrossNodes = settings.enforceDeployingReplicasAcrossNodes;
        this.http = settings.http;
        this.forwardSslSession = settings.forwardSslSession;
        this.disableAmLogForwarding = settings.disableAmLogForwarding;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public boolean getLastMileSecurity() {
        return this.lastMileSecurity;
    }

    public void setLastMileSecurity(boolean lastMileSecurity) {
        this.lastMileSecurity = lastMileSecurity;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public String getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(String updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public boolean isEnforceDeployingReplicasAcrossNodes() {
        return this.enforceDeployingReplicasAcrossNodes;
    }

    public void setEnforceDeployingReplicasAcrossNodes(boolean enforceDeployingReplicasAcrossNodes) {
        this.enforceDeployingReplicasAcrossNodes = enforceDeployingReplicasAcrossNodes;
    }

    public Http getHttp() {
        return this.http;
    }

    public void setHttp(Http http) {
        this.http = http;
    }

    public boolean isForwardSslSession() {
        return this.forwardSslSession;
    }

    public void setForwardSslSession(boolean forwardSslSession) {
        this.forwardSslSession = forwardSslSession;
    }

    public boolean isDisableAmLogForwarding() {
        return this.disableAmLogForwarding;
    }

    public void setDisableAmLogForwarding(boolean disableAmLogForwarding) {
        this.disableAmLogForwarding = disableAmLogForwarding;
    }

    public void setEnvironmentSpecificValues() throws DeploymentException {
        if (StringUtils.isEmpty((CharSequence)this.getResources().getMemory().getReserved())) {
            this.getResources().getMemory().setReserved("700Mi");
        }
        if (StringUtils.isEmpty((CharSequence)this.getResources().getMemory().getLimit())) {
            this.getResources().getMemory().setLimit(this.getResources().getMemory().getReserved());
        }
        if (StringUtils.isEmpty((CharSequence)this.getResources().getCpu().getReserved())) {
            this.getResources().getCpu().setReserved("500m");
        }
        if (StringUtils.isEmpty((CharSequence)this.getResources().getCpu().getLimit())) {
            this.getResources().getCpu().setLimit(this.getResources().getCpu().getReserved());
        }
        if (StringUtils.isEmpty((CharSequence)this.getUpdateStrategy())) {
            this.setUpdateStrategy("rolling");
        }
    }
}

