/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.cloudhub2;

import java.util.HashMap;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.fabric.RuntimeFabricClient;
import org.mule.tools.client.fabric.model.ApplicationModify;
import org.mule.tools.client.fabric.model.ApplicationRequest;
import org.mule.tools.client.fabric.model.AssetReference;
import org.mule.tools.client.fabric.model.DeploymentRequest;
import org.mule.tools.client.fabric.model.Target;
import org.mule.tools.deployment.cloudhub2.Cloudhub2Configuration;
import org.mule.tools.deployment.fabric.RequestBuilder;
import org.mule.tools.model.anypoint.Cloudhub2Deployment;

public class RequestBuilderCh2
extends RequestBuilder {
    public static final String ID = "id";

    protected RequestBuilderCh2(Cloudhub2Deployment deployment, RuntimeFabricClient client) {
        super(deployment, client);
    }

    @Override
    public DeploymentRequest buildDeploymentRequest() throws DeploymentException {
        ApplicationRequest applicationRequest = this.buildApplicationRequest();
        Target target = this.buildTarget();
        DeploymentRequest deploymentRequest = new DeploymentRequest();
        deploymentRequest.setName(this.deployment.getApplicationName());
        deploymentRequest.setApplication(applicationRequest);
        deploymentRequest.setTarget(target);
        applicationRequest.setConfiguration(this.createConfiguration());
        applicationRequest.setvCores(((Cloudhub2Deployment)this.deployment).getvCores());
        applicationRequest.setIntegrations(((Cloudhub2Deployment)this.deployment).getIntegrations());
        return deploymentRequest;
    }

    @Override
    protected ApplicationModify buildApplicationModify() {
        AssetReference assetReference = this.buildAssetReference();
        ApplicationModify applicationModify = new ApplicationModify();
        applicationModify.setRef(assetReference);
        applicationModify.setConfiguration(this.createConfiguration());
        applicationModify.setvCores(((Cloudhub2Deployment)this.deployment).getvCores());
        applicationModify.setIntegrations(((Cloudhub2Deployment)this.deployment).getIntegrations());
        return applicationModify;
    }

    public Object createConfiguration() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.deployment.getProperties() != null) {
            properties.put("properties", this.deployment.getProperties());
        }
        if (this.deployment.getSecureProperties() != null) {
            properties.put("secureProperties", this.deployment.getSecureProperties());
        }
        properties.put("applicationName", this.deployment.getApplicationName());
        HashMap<String, Object> loggingServiceProperties = null;
        if (((Cloudhub2Deployment)this.deployment).getScopeLoggingConfigurations() != null) {
            loggingServiceProperties = new HashMap<String, Object>();
            loggingServiceProperties.put("artifactName", this.deployment.getApplicationName());
            loggingServiceProperties.put("scopeLoggingConfigurations", ((Cloudhub2Deployment)this.deployment).getScopeLoggingConfigurations());
        }
        return new Cloudhub2Configuration(properties, loggingServiceProperties);
    }
}

