/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.model;

import java.io.File;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.tools.client.core.exception.DeploymentException;

public abstract class Deployment {
    @Parameter
    protected String artifact;
    @Parameter
    protected String applicationName;
    @Parameter
    protected String skip;
    @Parameter
    protected String muleVersion;
    @Parameter
    protected String javaVersion;
    @Parameter
    protected String releaseChannel;
    @Parameter
    protected Long deploymentTimeout;
    private String packaging;
    private String artifactId;
    private String groupId;
    private String version;

    public File getArtifact() {
        return Optional.ofNullable(this.artifact).map(File::new).orElse(null);
    }

    public void setArtifact(File artifact) {
        this.artifact = Optional.ofNullable(artifact).map(File::getPath).orElse(null);
    }

    public void setArtifact(String artifactPath) {
        this.artifact = artifactPath;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getSkip() {
        return this.skip;
    }

    public void setSkip(String skip) {
        this.skip = skip;
    }

    public Optional<String> getMuleVersion() {
        return Optional.ofNullable(this.muleVersion);
    }

    public void setMuleVersion(String muleVersion) {
        this.muleVersion = muleVersion;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public Optional<Long> getDeploymentTimeout() {
        return Optional.ofNullable(this.deploymentTimeout);
    }

    public void setDeploymentTimeout(Long deploymentTimeout) {
        this.deploymentTimeout = deploymentTimeout;
    }

    public void setDefaultValues(MavenProject project) throws DeploymentException {
        this.setBasicDeploymentValues(project);
        this.setEnvironmentSpecificValues();
    }

    public abstract void setEnvironmentSpecificValues() throws DeploymentException;

    protected void setBasicDeploymentValues(MavenProject project) throws DeploymentException {
        String deploymentTimeout;
        String packaging;
        String applicationPath;
        String muleVersion;
        String isSkip;
        String muleApplicationName = System.getProperty("mule.application.name");
        if (StringUtils.isNotBlank((CharSequence)muleApplicationName)) {
            this.setApplicationName(muleApplicationName);
        }
        if (StringUtils.isBlank((CharSequence)this.getApplicationName())) {
            this.setApplicationName(project.getArtifactId());
        }
        if (StringUtils.isNotBlank((CharSequence)(isSkip = System.getProperty("mule.skip")))) {
            this.setSkip(isSkip);
        }
        if (StringUtils.isBlank((CharSequence)this.getSkip())) {
            this.setSkip("false");
        }
        if (StringUtils.isNotBlank((CharSequence)(muleVersion = System.getProperty("mule.version")))) {
            this.setMuleVersion(muleVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)(applicationPath = System.getProperty("mule.artifact")))) {
            this.setArtifact(new File(applicationPath));
        }
        if (this.getArtifact() == null) {
            if (project.getArtifact() == null) {
                throw new DeploymentException("Artifact to be deployed could not be found. Please set its location setting -Dmule.artifact=path/to/jar or in the deployment configuration pom element");
            }
            this.setArtifact(project.getArtifact().getFile());
        }
        if (StringUtils.isNotBlank((CharSequence)(packaging = project.getPackaging()))) {
            this.setPackaging(packaging);
        }
        if (StringUtils.isNotBlank((CharSequence)(deploymentTimeout = System.getProperty("mule.deploymentConfiguration.timeout")))) {
            this.setDeploymentTimeout(Long.valueOf(deploymentTimeout));
        }
        this.setArtifactId(project.getArtifactId());
        this.setGroupId(project.getGroupId());
        this.setVersion(project.getVersion());
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getJavaVersion() {
        return Optional.ofNullable(this.javaVersion);
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public Optional<String> getReleaseChannel() {
        return Optional.ofNullable(this.releaseChannel);
    }

    public void setReleaseChannel(String releaseChannel) {
        this.releaseChannel = releaseChannel;
    }

    public boolean validateVersion() {
        return false;
    }
}

