/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.standalone;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.standalone.controller.MuleProcessController;
import org.mule.tools.client.standalone.controller.probing.PollingProber;
import org.mule.tools.client.standalone.controller.probing.Prober;
import org.mule.tools.client.standalone.controller.probing.deployment.DeploymentProbe;
import org.mule.tools.client.standalone.controller.probing.deployment.DeploymentProbeFactory;
import org.mule.tools.client.standalone.exception.MuleControllerException;
import org.mule.tools.deployment.artifact.ArtifactDeployer;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.standalone.StandaloneDeployment;
import org.mule.tools.utils.DeployerLog;

public class StandaloneArtifactDeployer
implements ArtifactDeployer {
    private static final Long DEFAULT_STANDALONE_DEPLOYMENT_TIMEOUT = 60000L;
    private final StandaloneDeployment deployment;
    private final DeployerLog log;
    private static final long DEFAULT_POLLING_DELAY = 1000L;
    private final MuleProcessController controller;
    private final Prober prober;

    public StandaloneArtifactDeployer(Deployment deployment, MuleProcessController controller, DeployerLog log, Prober prober) {
        this.deployment = (StandaloneDeployment)deployment;
        this.controller = controller;
        this.prober = prober;
        this.log = log;
    }

    public StandaloneArtifactDeployer(Deployment deployment, DeployerLog log) throws DeploymentException {
        this(deployment, StandaloneArtifactDeployer.getMuleProcessController(deployment), log, StandaloneArtifactDeployer.getProber(deployment));
    }

    private static Prober getProber(Deployment deployment) {
        return new PollingProber(deployment.getDeploymentTimeout().orElse(DEFAULT_STANDALONE_DEPLOYMENT_TIMEOUT), 1000L);
    }

    private static MuleProcessController getMuleProcessController(Deployment deployment) {
        return new MuleProcessController(((StandaloneDeployment)deployment).getMuleHome().getAbsolutePath());
    }

    public void waitForDeployments() throws DeploymentException {
        if (!this.deployment.getArtifact().exists()) {
            throw new DeploymentException("Application does not exist: " + this.deployment.getArtifact());
        }
        this.log.info("Waiting for artifact [" + this.deployment.getArtifact() + "] to be deployed.");
        String app = FilenameUtils.getBaseName((String)this.deployment.getArtifact().getName());
        try {
            DeploymentProbe probe = DeploymentProbeFactory.createProbe(this.deployment.getPackaging());
            this.prober.check(probe.isDeployed(this.controller, app));
        }
        catch (AssertionError e) {
            this.log.error("Couldn't deploy application [" + app + "] after [" + this.deployment.getDeploymentTimeout() + "] miliseconds. Check Mule Runtime log");
            throw new DeploymentException("Application deployment timeout.");
        }
    }

    protected void renameApplicationToApplicationName() throws DeploymentException {
        if (!FilenameUtils.getBaseName((String)this.deployment.getArtifact().getName()).equals(this.deployment.getApplicationName())) {
            try {
                File destApplication = new File(this.deployment.getArtifact().getParentFile(), this.deployment.getApplicationName() + ".jar");
                FileUtils.copyFile((File)this.deployment.getArtifact(), (File)destApplication);
                this.deployment.setArtifact(destApplication);
            }
            catch (IOException e) {
                throw new DeploymentException("Fail to rename [" + this.deployment.getArtifact() + "] to [" + this.deployment.getApplicationName() + "]");
            }
        }
    }

    public void verifyMuleIsStarted() throws MuleControllerException {
        this.log.info("Checking if Mule Runtime is running.");
        if (!this.controller.isRunning()) {
            throw new MuleControllerException("Mule Runtime is not running! Aborting.");
        }
    }

    public void addDomainFromStandaloneDeployment(StandaloneDeployment configuration) throws DeploymentException {
        if (configuration.getDomain().isPresent()) {
            this.log.info("Adding domain with configuration: " + configuration.getDomain());
            this.controller.deployDomain(configuration.getDomain().get().getAbsolutePath());
        } else {
            this.log.info("Domain configuration not found: " + configuration.getDomain());
        }
    }

    public String toString() {
        return String.format("StandaloneDeployer with [Controller=%s, log=%s, application=%s, timeout=%d, pollingDelay=%d ]", this.controller, this.log, this.deployment.getArtifact(), this.deployment.getDeploymentTimeout().get(), 1000L);
    }

    @Override
    public void deployDomain() throws DeploymentException {
        this.renameApplicationToApplicationName();
        File domain = this.deployment.getArtifact();
        Preconditions.checkArgument((domain != null ? 1 : 0) != 0, (Object)"Domain cannot be null");
        try {
            this.controller.deployDomain(domain.getAbsolutePath());
        }
        catch (MuleControllerException e) {
            this.log.error("Couldn't deploy domain: " + domain);
            throw new DeploymentException("Couldn't deploy domain: " + domain);
        }
    }

    @Override
    public void undeployDomain() throws DeploymentException {
        throw new DeploymentException("Undeployment of domains to Standalone is not supported");
    }

    @Override
    public void deployApplication() throws DeploymentException {
        this.renameApplicationToApplicationName();
        this.addDomainFromStandaloneDeployment(this.deployment);
        File application = this.deployment.getArtifact();
        Preconditions.checkState((application != null ? 1 : 0) != 0, (Object)"Application cannot be null");
        try {
            this.controller.deploy(application.getAbsolutePath());
        }
        catch (MuleControllerException e) {
            this.log.error("Couldn't deploy application: " + application);
            throw new DeploymentException("Couldn't deploy application: " + application);
        }
    }

    @Override
    public void undeployApplication() throws DeploymentException {
        File muleHome = this.deployment.getMuleHome();
        if (!muleHome.exists()) {
            throw new DeploymentException("MULE_HOME directory does not exist. Please verify the deployment configuration");
        }
        this.log.info("Using MULE_HOME: " + muleHome);
        this.undeploy(muleHome);
    }

    protected void undeploy(File muleHome) throws DeploymentException {
        File appsDir = new File(muleHome + "/apps/");
        for (File file : Objects.requireNonNull(appsDir.listFiles())) {
            if (!FilenameUtils.getBaseName((String)file.getName()).equals(this.deployment.getApplicationName())) continue;
            try {
                this.log.info("Deleting " + file);
                FileUtils.forceDelete((File)file);
                return;
            }
            catch (IOException e) {
                this.log.error("Could not delete " + file.getAbsolutePath());
                throw new DeploymentException("Could not delete directory [" + file.getAbsolutePath() + "]", e);
            }
        }
        throw new DeploymentException("Application " + this.deployment.getApplicationName() + " not found.");
    }
}

