/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.controller;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.mule.tools.client.standalone.exception.MuleControllerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOSController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOSController.class);
    protected static final String STATUS = "Mule(\\sEnterprise Edition)? is running \\(([0-9]+)\\)\\.";
    protected static final Pattern STATUS_PATTERN = Pattern.compile("Mule(\\sEnterprise Edition)? is running \\(([0-9]+)\\)\\.");
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final String MULE_HOME_VARIABLE = "MULE_HOME";
    protected final String muleHome;
    protected final String muleBin;
    protected final int timeout;

    public AbstractOSController(String muleHome, int timeout) {
        this.muleHome = muleHome;
        this.muleBin = this.getMuleBin();
        this.timeout = timeout > 0 ? timeout : 30000;
    }

    public String getMuleHome() {
        return this.muleHome;
    }

    public abstract String getMuleBin();

    public void start(String ... args) {
        int error = this.runSync("start", args);
        if (error != 0) {
            throw new MuleControllerException("The mule instance couldn't be started");
        }
    }

    public int stop(String ... args) {
        return this.runSync("stop", args);
    }

    public abstract int status(String ... var1);

    public abstract int getProcessId();

    public void restart(String ... args) {
        int error = this.runSync("restart", args);
        if (error != 0) {
            throw new MuleControllerException("The mule instance couldn't be restarted");
        }
    }

    protected int runSync(String command, OutputStream outputStream, String ... args) {
        Map<Object, Object> newEnv = this.copyEnvironmentVariables();
        return this.executeSyncCommand(command, args, newEnv, this.timeout, outputStream);
    }

    protected int runSync(String command, String ... args) {
        return this.runSync(command, (OutputStream)null, args);
    }

    private int executeSyncCommand(String command, String[] args, Map<Object, Object> newEnv, int timeout, OutputStream outputStream) throws MuleControllerException {
        CommandLine commandLine = new CommandLine(this.muleBin);
        commandLine.addArgument(command);
        commandLine.addArguments(args);
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)timeout);
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)Optional.ofNullable(outputStream).map(PumpStreamHandler::new).orElseGet(PumpStreamHandler::new));
        return this.doExecution((Executor)executor, commandLine, newEnv);
    }

    protected int doExecution(Executor executor, CommandLine commandLine, Map<Object, Object> env) {
        try {
            StringJoiner paramsJoiner = new StringJoiner(" ");
            for (String cmdArg : commandLine.toStrings()) {
                paramsJoiner.add(cmdArg.replaceAll("(?<=\\.password=)(.*)", "****"));
            }
            logger.info("Executing: " + paramsJoiner);
            return executor.execute(commandLine, env);
        }
        catch (ExecuteException e) {
            return e.getExitValue();
        }
        catch (Exception e) {
            throw new MuleControllerException("Error executing [" + commandLine.getExecutable() + " " + Arrays.toString(commandLine.getArguments()) + "]", e);
        }
    }

    protected Map<Object, Object> copyEnvironmentVariables() {
        HashMap<Object, Object> newEnv = new HashMap<Object, Object>(System.getenv());
        newEnv.put(MULE_HOME_VARIABLE, this.muleHome);
        return newEnv;
    }

    @VisibleForTesting
    protected static class InternalOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        protected InternalOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.write(b);
            System.out.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.buffer.flush();
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

