/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.verification.agent;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.agent.AgentClient;
import org.mule.tools.client.agent.model.Application;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.verification.DefaultDeploymentVerification;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.DeploymentVerificationStrategy;

public class AgentDeploymentVerification
implements DeploymentVerification {
    private static final String STARTED_STATUS = "STARTED";
    private final AgentClient client;
    private final DeploymentVerification verification;

    public AgentDeploymentVerification(AgentClient client) {
        this.client = client;
        this.verification = new DefaultDeploymentVerification(new AgentDeploymentVerificationStrategy());
    }

    @Override
    public void assertDeployment(Deployment deployment) throws DeploymentException {
        this.verification.assertDeployment(deployment);
    }

    private class AgentDeploymentVerificationStrategy
    implements DeploymentVerificationStrategy {
        private AgentDeploymentVerificationStrategy() {
        }

        @Override
        public Predicate<Deployment> isDeployed() {
            return deployment -> {
                Application application = AgentDeploymentVerification.this.client.getApplication(deployment.getApplicationName());
                return application != null && StringUtils.equals((CharSequence)application.state, (CharSequence)AgentDeploymentVerification.STARTED_STATUS);
            };
        }

        @Override
        public Consumer<Deployment> onTimeout() {
            return deployment -> AgentDeploymentVerification.this.client.undeployApplication(deployment.getApplicationName());
        }
    }
}

