/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.controller;

import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.mule.tools.client.standalone.controller.AbstractOSController;
import org.mule.tools.client.standalone.controller.Controller;
import org.mule.tools.client.standalone.controller.UnixController;
import org.mule.tools.client.standalone.controller.WindowsController;

public class MuleProcessController {
    public static final String MULE_PROCESS_CONTROLLER_TIMEOUT_PROPERTY = "mule.process.controller.timeout";
    public static final int DEFAULT_TIMEOUT = 60000;
    private final int controllerTimeout = Integer.getInteger("mule.process.controller.timeout", 60000);
    private final Controller controller;

    public MuleProcessController(String muleHome) {
        AbstractOSController osSpecificController = SystemUtils.IS_OS_WINDOWS ? new WindowsController(muleHome, this.controllerTimeout) : new UnixController(muleHome, this.controllerTimeout);
        this.controller = this.buildController(muleHome, osSpecificController);
    }

    protected Controller buildController(String muleHome, AbstractOSController osSpecificController) {
        return new Controller(osSpecificController, muleHome);
    }

    public boolean isRunning() {
        return this.getController().isRunning();
    }

    public void start(String ... args) {
        this.getController().start(args);
    }

    public void stop(String ... args) {
        this.getController().stop(args);
    }

    public int status(String ... args) {
        return this.getController().status(args);
    }

    public int getProcessId() {
        return this.getController().getProcessId();
    }

    public void restart(String ... args) {
        this.getController().restart(args);
    }

    public void deploy(String path) {
        this.getController().deploy(path);
    }

    public boolean isDeployed(String appName) {
        return this.getController().isDeployed(appName);
    }

    public File getArtifactInternalRepository(String artifactName) {
        return this.getController().getArtifactInternalRepository(artifactName);
    }

    public File getRuntimeInternalRepository() {
        return this.getController().getRuntimeInternalRepository();
    }

    public boolean isDomainDeployed(String domainName) {
        return this.getController().isDomainDeployed(domainName);
    }

    public void undeploy(String application) {
        this.getController().undeploy(application);
    }

    public void undeployDomain(String domain) {
        this.getController().undeployDomain(domain);
    }

    public void undeployAll() {
        this.getController().undeployAll();
    }

    public void installLicense(String path) {
        this.getController().installLicense(path);
    }

    public void uninstallLicense() {
        this.getController().uninstallLicense();
    }

    public void addLibrary(File jar) {
        this.getController().addLibrary(jar);
    }

    public void deployDomain(String domain) {
        this.getController().deployDomain(domain);
    }

    public File getLog() {
        return this.getController().getLog();
    }

    public File getLog(String appName) {
        return this.getController().getLog(appName);
    }

    public void addConfProperty(String value) {
        this.getController().addConfProperty(value);
    }

    protected Controller getController() {
        return this.controller;
    }

    protected int getControllerTimeout() {
        return this.controllerTimeout;
    }
}

