/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.fabric;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.mule.tools.client.AbstractMuleClient;
import org.mule.tools.client.fabric.model.DeploymentDetailedResponse;
import org.mule.tools.client.fabric.model.DeploymentModify;
import org.mule.tools.client.fabric.model.DeploymentRequest;
import org.mule.tools.client.fabric.model.Deployments;
import org.mule.tools.model.anypoint.RuntimeFabricDeployment;
import org.mule.tools.utils.DeployerLog;

public class RuntimeFabricClient
extends AbstractMuleClient {
    public static final String API_VERSION = "/v2";
    public static final String HYBRID_API = "/hybrid/api/v2";
    public static final String RESOURCES_PATH = "/hybrid/api/v2/organizations/%s/environments/%s";
    public static final String DEPLOYMENTS_PATH = "/hybrid/api/v2/organizations/%s/environments/%s/deployments";
    public static final String RUNTIME_FABRIC_TARGETS = "runtimefabric/api/organizations/%s/targets";
    public static final String RUNTIME_FABRIC_TARGET_INFO = "runtimefabric/api/organizations/%s/targets/%s";
    public static final String RUNTIME_FABRIC_DOMAIN_INFO = "runtimefabric/api/organizations/%s/targets/%s/environments/%s/domains";

    public RuntimeFabricClient(RuntimeFabricDeployment runtimeFabricDeployment, DeployerLog log) {
        super(runtimeFabricDeployment, log);
    }

    public Deployments getDeployments() {
        Response response = this.get(this.baseUri, this.getPathSupplier());
        this.checkResponseStatus(response, Response.Status.OK);
        return this.readEntityWithTimeout(() -> (Deployments)response.readEntity(Deployments.class));
    }

    public DeploymentDetailedResponse deploy(DeploymentRequest request) {
        this.log.info("Deploying " + request.name);
        Response response = this.post(this.baseUri, this.getPathSupplier(), (Object)new Gson().toJson((Object)request));
        this.checkResponseStatus(response, Response.Status.ACCEPTED);
        return this.readEntityWithTimeout(() -> (DeploymentDetailedResponse)response.readEntity(DeploymentDetailedResponse.class));
    }

    public DeploymentDetailedResponse redeploy(DeploymentModify modify, String deploymentId) {
        this.log.info("Redeploying...");
        Response response = this.patch(this.baseUri, this.getDeploymentPathSupplier(deploymentId), new Gson().toJson((Object)modify));
        this.checkResponseStatus(response, Response.Status.OK);
        return this.readEntityWithTimeout(() -> (DeploymentDetailedResponse)response.readEntity(DeploymentDetailedResponse.class));
    }

    public DeploymentDetailedResponse getDeployment(String deploymentId) {
        Response response = this.get(this.baseUri, this.getDeploymentPathSupplier(deploymentId));
        this.checkResponseStatus(response, Response.Status.OK);
        return this.readEntityWithTimeout(() -> (DeploymentDetailedResponse)response.readEntity(DeploymentDetailedResponse.class));
    }

    public DeploymentDetailedResponse deleteDeployment(String deploymentId) {
        Response response = this.delete(this.baseUri, this.getDeploymentPathSupplier(deploymentId));
        this.checkResponseStatus(response, Response.Status.NO_CONTENT);
        return this.readEntityWithTimeout(() -> (DeploymentDetailedResponse)response.readEntity(DeploymentDetailedResponse.class));
    }

    private Supplier<String> getDeploymentPathSupplier(String deploymentId) {
        return () -> String.format(this.getPathSupplier().get() + "/%s", deploymentId);
    }

    public Supplier<String> getPathSupplier() {
        return () -> String.format(this.getDeploymentsPath(), this.getOrgId(), this.getEnvId());
    }

    public Supplier<String> getAgentsPathSupplier() {
        return () -> String.format(RUNTIME_FABRIC_TARGETS, this.getOrgId());
    }

    public JsonArray getTargets() {
        Response response = this.get(this.baseUri, this.getAgentsPathSupplier());
        this.checkResponseStatus(response, Response.Status.OK);
        return ((JsonElement)new Gson().fromJson(this.readEntityWithTimeout(() -> (String)response.readEntity(String.class)), JsonElement.class)).getAsJsonArray();
    }

    public JsonObject getTargetInfo(String targetId) {
        Response response = this.get(this.baseUri, String.format(RUNTIME_FABRIC_TARGET_INFO, this.getOrgId(), targetId));
        this.checkResponseStatus(response, Response.Status.OK);
        return ((JsonElement)new Gson().fromJson(this.readEntityWithTimeout(() -> (String)response.readEntity(String.class)), JsonElement.class)).getAsJsonObject();
    }

    public JsonArray getDomainInfo(String targetId) {
        Response response = this.get(this.baseUri, String.format(RUNTIME_FABRIC_DOMAIN_INFO, this.getOrgId(), targetId, this.getEnvId()));
        this.checkResponseStatus(response, Response.Status.OK);
        return ((JsonArray)new Gson().fromJson(this.readEntityWithTimeout(() -> (String)response.readEntity(String.class)), JsonArray.class)).getAsJsonArray();
    }

    protected String getDeploymentsPath() {
        return DEPLOYMENTS_PATH;
    }
}

