/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.mule.tools.maven.plugin.domain.AbstractMuleMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterResourcesMojo
extends AbstractMuleMojo {
    private MavenResourcesFiltering resourceFilter;
    private String encoding;
    private MavenSession session;
    private boolean filterAppDirectory;
    private boolean escapeWindowsPaths;
    private boolean supportMultiLineFiltering;
    private List<?> nonFilteredFileExtensions;
    private List<?> filters;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.filterAppDirectory) {
            return;
        }
        this.getLog().info((CharSequence)("filtering resources from " + this.appDirectory.getAbsolutePath()));
        this.filterResources();
    }

    private void filterResources() throws MojoExecutionException {
        try {
            MavenResourcesExecution execution = new MavenResourcesExecution(this.getResources(), this.getFilteredAppDirectory(), this.project, this.encoding, this.filters, Collections.EMPTY_LIST, this.session);
            execution.setEscapeWindowsPaths(this.escapeWindowsPaths);
            execution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            if (this.nonFilteredFileExtensions != null) {
                execution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.resourceFilter.filterResources(execution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Error while filtering Mule config files", (Exception)((Object)e));
        }
    }

    private List<Resource> getResources() {
        Resource appFolderResource = new Resource();
        appFolderResource.setDirectory(this.appDirectory.getAbsolutePath());
        appFolderResource.setFiltering(true);
        return Arrays.asList(appFolderResource);
    }
}

